# CRM Interno

CRM é um sistema robusto e personalizável para gerenciamento de clientes, contatos, leads, projetos e vendas. Nosso CRM foi projetado para ajudar sua empresa a gerenciar relacionamentos e processos de maneira eficiente.


## Pré-requisitos

Antes de rodar o CRM, você precisa garantir que as seguintes dependências estão instaladas:

- **PHP 8.2** (ou versão superior)
- **Node.js versão 22** (recomendado)
- **Composer** (para instalar as dependências PHP)
- **npm** (para instalar as dependências JavaScript)

## Conventional Commits

Este repositório segue a convenção **Conventional Commits** para manter um histórico de commits claro, organizado e fácil de entender. Usar essa convenção facilita a colaboração entre os desenvolvedores, a integração contínua, a geração automática de changelogs e a manutenção do código a longo prazo.

Não esqueça de incluir o .vscode/bookmarks.json no commit caso tenha modificações

## Bookmarks

Utilize os **bookmarks** para ganho de produtividade, adicione somente os pontos importantes do arquivo que está sendo trabalho e rotule-os.

## Instalação das Dependências

1. **Instale as dependências PHP**:
   Primeiramente, execute o comando abaixo para instalar as dependências PHP necessárias (raiz)
   ```bash
   composer install

2. **Instale as dependências JS**:
    Agora, execute o comando abaixo para instalar as dependências JS (raiz)
    ```bash
    npm install