<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Insert, PreparedQuery, Update};
use App\Core\{Controller};
use App\Core\Helpers\Helper;

class Comissionamento extends Controller
{
    use Insert, PreparedQuery, Update;

    private string $table = 'orcamentos';

    public function __construct()
    {
        parent::__construct();   
    }

    /**
     * Método responsável por obter o comissionamento dos usuários
     * 
     *
     */
    public function obtemComissionamento()
    {
        // $dataInicio = $_REQUEST['dtInicio'] ?? date('Y-m-01');
        // $dataFinal  = $_REQUEST['dtInicio'] ?? date('Y-m-t');

        $yearMonth = $_REQUEST['ano_mes'] ?? date('Y-m');

        try {
            $query = 
                "SELECT 
                    u.id as id_usuario,
                    u.nome,
                    DATE_FORMAT(o.data_retorno, '%m/%Y') as mes_ano,
                    SUM(
                        CASE 
                            WHEN sub_p.precificacao_nome = 'menor_preco' THEN (sub_p.valor_total_produto * (ct.menor_preco_comissao / 100))
                            WHEN sub_p.precificacao_nome = 'condicao_ideal' THEN (sub_p.valor_total_produto * (ct.condicao_ideal_comissao / 100))
                            WHEN sub_p.precificacao_nome = 'preco_com_margem' THEN (sub_p.valor_total_produto * (ct.preco_com_margem_comissao / 100))
                            ELSE 0 -- Valor padrão caso não encontre correspondência
                        END
                    ) AS comissao
                FROM orcamentos AS o
                LEFT JOIN (
                    SELECT 
                        op.id_orcamento_FK,
                        op.precificacao_nome,
                        op.valor_total_produto
                    FROM orcamentos_produtos AS op
                    INNER JOIN (
                        SELECT id_orcamento_FK, MAX(id_orcamento_historico_FK) AS max_id
                        FROM orcamentos_produtos
                        GROUP BY id_orcamento_FK
                    ) AS subquery
                    ON op.id_orcamento_FK = subquery.id_orcamento_FK AND op.id_orcamento_historico_FK = subquery.max_id
                ) AS sub_p ON o.id = sub_p.id_orcamento_FK
                LEFT JOIN usuarios AS u ON o.create_by = u.id
                LEFT JOIN config_taxas AS ct ON 1 = 1 -- Join constante para permitir o uso das colunas de ct no CASE
                WHERE 1 = 1 
                    AND o.status_user = 21
                    AND o.convertido_ordem_servico = 1
                    AND u.tester = 0
                    AND DATE_FORMAT(o.data_retorno, '%Y-%m') = ?
        
                GROUP BY u.id, mes_ano
                ORDER BY u.id, mes_ano
            ";
        
            return self::preparedQuery($query, [$yearMonth]);

        } catch (\Throwable $th) {
            Helper::jsonResponse(['error' => $th->getMessage()], 400);
        }
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'obtemComissionamento' => Helper::jsonResponse($this->obtemComissionamento($_REQUEST['usuarioId'] ?? null)),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Comissionamento') {
    $instance = new Comissionamento();
    $instance->setRoute($_REQUEST['action']);
}
