<?php

namespace App\Core;
require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn};
use App\Core\Helpers\Helper;

class CostsHistory
{
    use Create, PreparedQuery, Update;

    private $conn = null;
    private string $table = '';
    private ?int $id_usuario = null;

    public function __construct()
    {
        $this->conn = Conn::openConn();
        $this->table = 'historico_custos';
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    public function saveOldInfo(array $data): bool
    {
        try {
            self::Create([
                // h1
                'imposto' => $data['impostoValorAnterior'],
                'custo_administrativo' => $data['custoAdmValorAnterior'],
                'comissao' => $data['comissaoValorAnterior'],
                'desconto_financeiro' => $data['desconfoFinanceiroValorAnterior'],

                // h2
                'imposto2' => $data['imposto2ValorAnterior'],
                'comissao2' => $data['comissao2ValorAnterior'],

                'id_usuario_FK' => $this->id_usuario,
                'created_by' => $this->id_usuario,
            ]);

            return true;
        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), $e->getCode() ?? 400);
            return false;
        }
    }
}
