<?php
namespace App\Core; 

use App\Core\Helpers\Helper;

class FileManager
{
    /**
     * @var const PATH_FILE_BASE - caminho para o diretório de contém arquivos do sistema
     */
    const PATH_FILE_BASE = __DIR__ . '/../../view/assets/file/';

    /**
     * Método responsável por fazer o upload da imagem
     *
     * @param string $url - Nome da pasta onde irá ficar salvo a img
     * @param array|null $photo - Imagem do usuário recebida pelo front
     * @param integer $size_file_max - Tamanho máximo da imagem
     *
     * @return string|null
     */
    public static function uploadFile(string $url, ?array $photo, int $size_file_max = 5): ?string
    {
        if (!self::validateImageSize($photo, $size_file_max)) return false;

        $path = self::PATH_FILE_BASE . $url;  /** Criando a variável para o caminho da pasta onde irá ficar salvo a img */
        $extension_file = explode(".", $photo['name']);  /** explode para pegar o tipo de img */
        $name_file = str_shuffle(hash('ripemd160', 'My New System Photo')).date('dmYHis').'.'.end($extension_file);  /**  cria o hash para codificar a img */

        move_uploaded_file($photo['tmp_name'], $path . $name_file);  /**  envia a foto para a pasta definida anteriormente */

        return $name_file;
    }

    /**
     * Método responsável por validar o tamanho da imagem
     *
     * @param array|null $photo - Imagem do usuário recebida pelo front
     * @param integer $size - Tamanho máximo da imagem
     *
     * @return boolean
     */
    public static function validateImageSize(?array $photo, int $size = 5): bool
    {
        $max_limit_image = $size * 1024 * 1024;
        if (!isset($photo)) {
            return false;
        }

        if ($photo['size'] > ($max_limit_image)) {
            $max_limit_image = $max_limit_image / 1024 / 1024;
            Helper::jsonResponse("Erro: o tamanho máximo da imagem é de {$max_limit_image} MB. {$photo['size']} - {$max_limit_image}", 400);
            return false;
        }

        return true;
    }

    /**
     * Este método remove do diretório o arquivo passado como argymento
     *
     * @param string $url -- caminho diretorio final do arquivo
     * @param string|array -- nome do arquivo a ser deletado
     *
     * @return bool|Throwable
     *
     * @todo implementar file_exists
     */
    public static function delete(string $url, string|array $file_name)
    {
        try {
            if (is_string($file_name)) {
                unlink(self::PATH_FILE_BASE . $url . $file_name);
                return true;
            }

            foreach ($file_name as $key => $value) {
                $filename = $value['nome'];
                unlink(self::PATH_FILE_BASE . $url . $filename);
            }

            return true;
        } catch (\Throwable $e) {
            return $e->getMessage();
        }
    }


    public static function organizeFiles(array $data): array
    {
        $separatedData = [];

        // Obtém o número de imagens
        $numImages = count($data['name']);
        
        // Itera sobre o número de imagens
        for ($i = 0; $i < $numImages; $i++) {
            $imageData = [];
        
            // Itera sobre as chaves dos arrays
            foreach ($data as $key => $values) {
                $imageData[$key] = $data[$key][$i];
            }
        
            // Adiciona o subarray contendo as informações da imagem
            $separatedData[] = $imageData;
        }

        return $separatedData;
    }
}