<?php
namespace App\Core\Interfaces; 

require_once __DIR__ . '/StandardClassInterface.php';

interface LoginInterface extends StandardClassInterface
{
    /**
     * Método responsável por validar login
     * 
     * @param string $mail - e-mail de acesso
     * @param string $pass - senha de acesso
     * 
     * @return void
     */
    public function validateLogin(string $mail, string $pass): void;

    /**
     * Método responsável por verificar se usuário já está logado na tela de login e fazer redirecionameto
     */
    public function isLogged(): void;
}