<?php
namespace App\Core\Middlewares;

use Exception, Closure;

class AuthenticationMiddleware
{    
    /**
     * Método responsável por validar sessão do usuário e executar a função solicitada
     * 
     * @param Closure $func - Função anônina para executar
     * 
     * @return Closure $func - Retorna a execução da função que foi passada por argumento
     * 
     * @todo Implementar Redis
     * @todo Implementar Monolog
     * @todo Realizar consulta SQL para guardar login do usuário em cache para realizar validação toda vez que usuário fazer consulta
     * @todo Rodar Redis antes de validar session e atribuir valor do cache para session
     */
    public function handle(Closure $func): Closure
    {
        # Caching code...

        if (!isset($_SESSION['user'])) {
            // Destruir todas as sessões e derrubar o usuário
            session_destroy();
            // Implementar monolog
            throw new Exception('Usuário não autenticado', 401);
        }
        
        return $func();
    }
}