<?php

namespace App\Core\Precificacao\Formulas;

use App\Core\Helpers\Helper;
use App\Core\Precificacao\Interfaces\CalculoValorAdicionalInterface;

class CalculoValorAdicionalOrcamento implements CalculoValorAdicionalInterface
{
    /**
     * Método responsável por aplicar o valor adicional em cada produto de forma proporcional
     * 
     * @param array $produtos - Produtos a serem calculados
     * @param float $valorAdicional - Valor adicional a ser aplicado
     * @param float $valorTotal - Valor total dos produtos
     * 
     * @return array Produtos com valor adicional aplicado
     */
    public function calcular(array $produtos, float $valorAdicional, float $valorTotal): array
    {
        foreach ($produtos as $key => $produto) {
            $soma = ((float) $produto['valor_final_formula_harvard'] / $valorTotal) * $valorAdicional;
            $produtos[$key]['valor_final'] = (float) $produto['valor_final_formula_harvard'] + $soma;
        }

        $produtos = array_map(function($produto) {
            $produto['valor_unitario_final'] = Helper::truncateTwoDecimals($produto['valor_final'] / $produto['qtd']);
            $produto['valor_final'] = Helper::truncateTwoDecimals($produto['valor_unitario_final'] * $produto['qtd']);
            
            return $produto;
        }, $produtos);

        return $produtos;
    }
}