<?php
namespace App\Core\Precificacao\Interfaces;

/**
 * @package App\Core\Precificacao
 */
interface CalculoDescontoInterface
{
    /**
     * Método responsável por calcular o valor total com desconto
     * 
     * @param string $tipoDeDesconto - Tipo de desconto a ser aplicado (R$ ou %)
     * @param float $valorDesconto - Valor do desconto
     * @param float $valorTotal - Valor Total antes de aplicar o desconto
     * 
     * @return array - Informações do valor total com desconto e o valor a ser descontado
     */
    public function calcular(string $tipoDeDesconto, float $valorDesconto, float $valorTotal): array;
}
