<?php 

namespace App\Core\Precificacao\Interfaces;

/**
 * @package App\Core\Precificacao
 */
interface CalculoJurosParcelamentoInterface
{
    /**
     * Interface responsável por calcular o valor total acrescido de juros
     * 
     * @param int $parcelas - Quantidade de parcelas
     * @param float $juros - Juros a ser aplicado (em porcentagem)
     * @param float $valorTotal - Valor Total antes de aplicar o juros
     * 
     * @return array - Array com informações das parcelas, juros e valor total
     */
    public function calcular(int $parcelas, float $juros, float $valorTotal): array;
}