<?php
namespace App\Core; 

use Exception;

abstract class RenderTable
{
    /**
     * Método responsável por retornar a tabela selecionada (como se fosse um enum)
     * Método para evitar erros em queries e facilitar refatoração se necessário
     * Favor manter em órdem alfabética
     * 
     * @param string $table
     * 
     * @return string $table
     * 
     * @deprecated
     */
    public static function table(string $table)
    {
        if (preg_match('/[^a-zA-Z0-9$_]/', $table)) throw new Exception('O nome da tabela contém caracteres inválidos', 400);

        return match ($table) {
            // C
            'clientes'            => 'clientes',
            'config_custos'       => 'config_custos',
            'config_juros'        => 'config_juros',
            'config_taxas'        => 'config_taxas',
            'contatos'            => 'contatos',
            'codigos'             => 'codigos',
            'config_orcamentos'   => 'config_orcamentos',
            'custos_historico'    => 'historico_custos', // ANTIGO (ALTERADO)

            // H
            'historico_custos'    => 'historico_custos',
            'historico_juros'     => 'historico_juros',
            'historico_taxas'     => 'historico_taxas',

            // J
            'juros_historico'     => 'historico_juros', // ANTIGO (ALTERADO)

            // N
            'notificacoes'        => 'notificacoes',

            // O
            'orcamentos'          => 'orcamentos',
            'orcamentos_historico'=> 'orcamentos_historico',
            'orcamentos_produtos' => 'orcamentos_produtos',
            'orcamentos_dialogos' => 'orcamentos_dialogos',

            // P
            'produtos'            => 'produtos',
            'produtos_foto'       => 'produtos_foto',

            // R
            'recuperar_senha'     => 'recuperar_senha',

            // S
            'status'              => 'status',
            'suporte'             => 'suporte',

            // T
            'taxas_historico'     => 'historico_taxas', // ANTIGO (ALTERADO)

            // U
            'usuarios'            => 'usuarios',
            'usuarios_codigos'    => 'usuarios_codigos',

            default               => throw new Exception("Erro ao processar solicitação", 400)
        };
    }
}