<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn, RenderTable, TaxHistory};
use Exception;


use App\Core\Helpers\Helper;

class Tax
{
    use Create, PreparedQuery, Update;

    private $conn = null;

    private string $table = '';
    private ?int $id_usuario = null;


    public function __construct()
    {
        $this->conn = Conn::openConn();
        $this->table = RenderTable::table('config_taxas');
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    public function getPorcentagemComissao(string $tipoPrecificacao)
    {
        $name = $tipoPrecificacao . '_comissao';

        return self::PreparedQuery(
            "SELECT $name
            FROM config_taxas
            LIMIT 1
        ")[0][$name];
    }

    /**
     * Método responsável por atualizar os dados de um registro na tabela do sistema.
     * @param array $data Um array contendo os dados a serem atualizados.
     */
    public function update(array $data)
    {
        try {
            $tax = [
                'menor_preco' => Helper::formatFloatToAbsValue($data['menorPreco']),
                'condicao_ideal' => Helper::formatFloatToAbsValue($data['condicaoIdeal']),
                'preco_com_margem' => Helper::formatFloatToAbsValue($data['precoComMargem']),

                'menor_preco_comissao' => Helper::formatFloatToAbsValue($data['menorPrecoComissao']),
                'condicao_ideal_comissao' => Helper::formatFloatToAbsValue($data['condicaoIdealComissao']),
                'preco_com_margem_comissao' => Helper::formatFloatToAbsValue($data['precoComMargemComissao']),
                
                'updated_by' => $this->id_usuario,
            ];

            $rowsAffected = self::updateQuery($this->table, $tax, ['id' => (int)$data['id']]);

            if ($rowsAffected === false) {
                Helper::jsonResponse("Erro ao atualizar.", 400);
            }

            if ($rowsAffected === 0) {
                Helper::jsonResponse("Nenhum valor foi atualizado.", 200);
            }

            $taxHistory = new TaxHistory();
            if (!$taxHistory->saveOldInfo($data)) {
                throw new Exception("Erro ao salvar histórico", 400);
            }

            Helper::jsonResponse('Os dados foram atualizados com sucesso.');
        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), $e->getCode() ?? 400);

        }
    }

    public function getTaxFromMultipleProducts($products): array
    {
        $tax = [];

        try {
            // Futuramente implementar lógica para se já estiver pego uma taxa, não rodar outro foreach e somente replicar a informação ao id do produto
            foreach ($products as $key => $value) {
                $data = self::PreparedQuery("SELECT {$value['precificacao']} FROM ". RenderTable::table('config_taxas') ." LIMIT 1");
                $tax[$key] = (float) $data[0][$value['precificacao']];
            }

        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), 400);
        }   

        return $tax;
    }

    /**
     *
     * @todo refatorar o id
     */
    public function show(): array
    {
        return self::PreparedQuery("SELECT * FROM " . RenderTable::table('config_taxas'));
    }

    /**
     * @todo Implementar higienização do parâmetro
     */
    public function get(string $column)
    {
        $data = self::PreparedQuery("SELECT {$column} FROM {$this->table}");
        return $data[0][$column];
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     * @param string $route
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'update' => $this->update($_POST),
//             'preparedModalStore' => $this->preparedModalStore(),
//             'store' => $this->store($_REQUEST),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

// testar futuramente end(get_declared_classes())

if (isset($_POST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Tax') {
    $instance = new Tax();
    $instance->setRoute($_REQUEST['action']);
}
