<?php

namespace App\Core;
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{PreparedQuery};
use App\Core\{Controller, Customer, Contact, RenderTable};
use App\Core\Helpers\Helper;
use Exception;

/**
 * Inicialmente iremos trabalhar somente com consulta nessa classe
 */
class Timeline extends Controller
{
    use PreparedQuery;

    private string $table = '';

    private ?int $clienteId = null;

    public function __construct()
    {
        parent::__construct();
        $this->table = RenderTable::table('contatos');
        $this->clienteId = isset($_GET['clienteId']) ? (int) $_GET['clienteId'] : null;
    }

    /**
     * Método responsável por criar a timeline de contatos, orçamentos e diálogos com o cliente
     *
     * @todo necessário fazer com ordenação
     * @todo futuramente estudar necessidade de criar paginação
     */
    public function show(): array
    {
        if (!isset($this->clienteId)) {
            throw new Exception('Cliente não informado', 400);
        }

        $sql = 
            "SELECT * FROM (
                SELECT 
                    DATE_FORMAT(o.create_at, '%d/%m/%Y às %H:%i') AS create_at, 
                    o.dialogo,
                    'orcamento' AS tipo_id,
                    o.id,
                    o.create_at AS ordering_column,
                    u.nome AS create_by
                FROM orcamentos AS o
                LEFT JOIN usuarios u ON u.id = o.create_by
                WHERE o.id_cliente_FK = ?

                UNION ALL

                SELECT 
                    DATE_FORMAT(od.create_at, '%d/%m/%Y às %H:%i') AS create_at, 
                    od.message AS dialogo,
                    'chat_orcamento' AS tipo_id,
                    od.id_orcamento_FK AS id,
                    od.create_at AS ordering_column,
                    u.nome AS create_by
                FROM orcamentos_dialogos AS od
                LEFT JOIN usuarios u ON u.id = od.id_usuario_FK
                WHERE od.id_orcamento_FK IN (
                    SELECT id FROM orcamentos o WHERE o.id_cliente_FK = ?
                )

                UNION ALL

                SELECT 
                    DATE_FORMAT(c.create_at, '%d/%m/%Y às %H:%i') AS create_at, 
                    c.dialogo,
                    'contato' AS tipo_id,
                    c.id,
                    c.create_at AS ordering_column,
                    u.nome AS create_by
                FROM contatos AS c
                LEFT JOIN usuarios u ON u.id = c.create_by
                WHERE c.cliente = ?
            ) AS combined_results
            ORDER BY ordering_column DESC";

        return self::PreparedQuery($sql, [$this->clienteId, $this->clienteId, $this->clienteId]);
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            // 'store' => $this->store($_POST, $_FILES),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Timeline') {
    $instance = new Timeline();
    $instance->setRoute($_REQUEST['action']);
}