<?php
namespace App\Core\Utilities;

use Exception;

trait Delete
{
    public function delete(string $where, mixed $equals)
    {
        $type = match (gettype($equals)) {
            'string'  => 's',
            'integer' => 'i',
            'double'  => 'd',
            default   => throw new Exception("Tipo inválido para o parâmetro equals", 400),
        };

        $stmt = $this->conn->prepare("DELETE FROM {$this->table} WHERE {$where} = ?");
        $stmt->bind_param($type, $equals);
        $stmt->execute();

        if ($stmt->affected_rows === -1) {
            throw new Exception("Erro ao executar a consulta: " . $stmt->error, 400);
        }

        return $stmt->affected_rows;
    }
}