<?php
namespace App\Core\Utilities;

use App\Core\Helpers\Helper;
use Exception;

trait PreparedQuery 
{
    public function preparedQuery(string $sql, array $params = []) {

        $stmt = $this->conn->prepare($sql);

        if (!$stmt) {
            throw new Exception("Erro na preparação da consulta: " . $this->error);
        }

        if (!empty($params)) {
            $types = "";
            $values = [];

            foreach ($params as $param) {
                switch (gettype($param)) {
                    case "integer":
                        $types .= "i";
                        break;
                    case "double":
                        $types .= "d";
                        break;
                    case "string":
                        $types .= "s";
                        break;
                    default:
                        $types .= "s";
                        break;
                }

                $values[] = $param;
            }

            $bindParams = array_merge([$types], $values);

            $refs = [];
            foreach($bindParams as $key => $value) {
                $refs[$key] = &$bindParams[$key];
            }

            call_user_func_array([$stmt, 'bind_param'], $refs);
        }

        if (!$stmt->execute()) {
            throw new Exception("Erro na execução da consulta: " . $stmt->error);
        }

        $result = $stmt->get_result();

        if (!$result) {
            throw new Exception("Erro na obtenção do resultado: " . $stmt->error);
        }

        $rows = [];
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }

        mysqli_free_result($result);
        $stmt->close();

        return $rows;
    }
}


