<?php 

namespace App\Core\Utilities;

/**
 * Class QueryString
 * 
 * Esta classe é responsável por gerenciar os parâmetros de uma URL.
 */
class QueryString implements \Stringable
{
    private array $params = [];

    public function add(string $key, string $value): void {
        $this->params[$key] = $value;
    }

    public function __toString(): string {
        return http_build_query($this->params);
    }
    
    public function getParams() {
    	return $this->params;
    }
}

// exemplo de uso:

// $query = new QueryString();
// $query->add('page', '1');
// $query->add('sort', 'desc');

// $url = "https://example.com/search?$query";
// echo $url . PHP_EOL; // Saída: https://example.com/search?page=1&sort=desc