$('#btn-open-modal-edit-budget').on('click', function () {
    const idOrcamento = parseInt($('#modal-view-id-budget').val());

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Orcamentos.php`,
        data: {
            action: 'getDadosOrcamento',
            idOrcamento: idOrcamento
        },
        beforeSend: function () {
            fat_alert({
                type: 'info',
                title: 'Aguarde um momento 🤓',
                message: 'Estamos carregando as informações',
                timer: 5000
            });
        },
        success: function (data) {
            // É necessário limpar antes de renderizar os novos dados
            // Caso contrário, os dados antigos ficam no modal e podem ser misturados com os novos
            modalCreateSanitizeInputs();

            modalCreateToEdit({
                id: idOrcamento,
                data: data
            });

            fat_alert({
                type: 'dark',
                title: 'Informações carregadas 😊✅',
                message: 'Altere as informações necessárias e clique em salvar!',
                timer: 6000
            });

            $('#modal-view-budget').modal('hide');
            $('#modal-new-budget').modal('show');
            // abrir o modal create
            // renderizar informações no mdal

        },
        error: function (xhr) {
            fat_alert({
                type: 'danger',
                title: 'Oops... 😕',
                message: 'Ocorreu um problema ao carregar as informações. Atualize a página e tente novamente!',
                timer: 6000
            });

            console.log(xhr);
        }
    });

});

async function getProductsBudgetId(id) {
    return await $.ajax({
        method: 'GET',
        dataType: 'JSON',
        url: `${path_core}Orcamentos.php?action=getProductsById&id=${id}`,
        error: function (xhr) {
            fat_alert({
                type: 'danger',
                title: 'Oops... 😕',
                message: 'Ocorreu um problema ao carregar os produtos deste orçamento! <br>Se quiser continuar mesmo assim, deverá selecionar os produtos novamente. Se o problema persistir, contate o suporte!'
            });
        }
    })
}

async function countHistoryBudget(id) {
    return await $.ajax({
        method: 'GET',
        dataType: 'JSON',
        url: `${path_core}Orcamentos.php?action=countHistoryBudget&id=${id}`,
        error: function (xhr) {
            console.log(xhr);
        }
    })
}

function modalCreateToEdit(obj) {

    getProductsBudgetId(obj.data.id).then(produtos => {

        const first = $('#div-item').children().first();

        console.log(produtos);
        
        produtos.forEach((el, i) => {
            if (i == 0) {
                first.find('.select-product').val(el.id_produto_FK).trigger('change');
                first.find('.select-tax').val(el.precificacao_nome);
                first.find('.qtd-mao-obra').val(el.qtd_mao_obra);
                first.find('.qtd-produto').val(el.qtd);
                first.find('.select-personalizacao').val(el.id_personalizacao_FK).trigger('change');

                if (el.valor_manual_unitario != null) {
                    first.find('.checkbox-valor-manual').prop('checked', true).trigger('change');
                    const valorUnitarioFormatadoBRL = parseFloat(el.valor_manual_unitario).toLocaleString('pt-br', { style: 'currency', currency: 'BRL' });
                    first.find('.valor-manual').val(valorUnitarioFormatadoBRL);
                }
                return;
            }

            let content = 
                `<div data-agroupment-budget>
                    <div class="row mt-3">${html_clone_product}</div>
                    <div class="text-end text-danger mt-n2">
                        <small class="c-p" onclick="removeBudgetProduct()">Remover</small>
                    </div>
                </div>`;

            $('#render-new-product-budget').append(content);

            // Sempre irá obter o último elemento, pois a cada iteração é adicionado um novo elemento
            const last = $('#render-new-product-budget').children().last();

            last.find('.select-product').val(el.id_produto_FK).trigger('change');
            last.find('.select-tax').val(el.precificacao_nome);
            last.find('.qtd-mao-obra').val(el.qtd_mao_obra);
            last.find('.qtd-produto').val(el.qtd);
            last.find('.select-personalizacao').val(el.id_personalizacao_FK).trigger('change');
            if (el.valor_manual_unitario != null) {
                last.find('.checkbox-valor-manual').prop('checked', true).trigger('change');
                const valorUnitarioFormatadoBRL = parseFloat(el.valor_manual_unitario).toLocaleString('pt-br', { style: 'currency', currency: 'BRL' });
                last.find('.valor-manual').val(valorUnitarioFormatadoBRL);
            }

            activeCheckboxValorManual();
        });

        $('.select-product').select2({
            dropdownParent: $("#modal-new-budget"),
            width: '100%'
        });
    });

    $('#modal-title-budget').text('Editar orçamento');

    $('#type-modal').val(1);
    
    $('#pessoa-contato').val(obj.data.contato);
    $('#data-retorno').val(obj.data.data_retorno);
    $('#id-budget-update').val(obj.id);
    $('#select-customers').val(obj.data.id_cliente_FK).trigger('change');
    $('#dialog-client').val(obj.data.dialogo);
    $('#select-fees').val(obj.data.n_parcelas + '-' + obj.data.porcentagem_juros);
    $('#entrada-pgto').val(obj.data.entrada)
    $('#entrada-tipo').val(obj.data.entrada_tipo)
    $('#valor-adicional').val(obj.data.valor_adicional)
    $('#desconto-pgto').val(obj.data.desconto)
    $('#desconto-tipo').val(obj.data.desconto_tipo)
    $('#prazo-entrega').val(obj.data.prazo_entrega)
    $('#tipo-frete').val(obj.data.frete_tipo);

    // Teve a necessidade neste momento de fazer essa pequena adaptação kkkkkk, um dia vou resolver isso
    setTimeout(() => {
        $('#select-status').val(obj.data.id_status_FK).trigger('change');
    }, 500);
    
    if (obj.data.frete_tipo == 'CIF') {
        $('#div-cif').removeClass('d-none');
        $('#valor-frete').val(obj.data.frete)
    }


    quill_observacao_produto.clipboard.dangerouslyPasteHTML(obj.data.observacoes);
}

/**
 * Irá trazer as informações do orçamento já realizado em um modal
 */
function viewBudget(id) {
    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Budgets.php`,
        data: {
            action: 'viewBudget',
            id: id
        },
        success: function (data) {

            if (data.orcamento_info.desconto_status == -1) {
                showModalChangeStatusDesconto(
                    id, 
                    data.orcamento_info.valor_total, 
                    data.orcamento_info.desconto_valor,
                    data.is_admin
                );
                return;
            }

            let html_product = '';

            data.produtos.forEach(el => {
                let precificicao_info = '';

                switch (el.precificacao_nome) {
                    case 'menor_preco':
                        precificicao_info = 'Menor preço'
                        break;
                    case 'condicao_ideal':
                        precificicao_info = 'Condição ideal'
                        break;
                    case 'preco_com_margem':
                        precificicao_info = 'Preço com margem'
                        break;
                }

                html_product += `
                    <div class="row">
                        <div class="form-group mb-3">
                            <label class="form-label">Informações do produto</label>
                            <div class="input-group group-product-budget">
                                <span class="input-group-text">Qtd</span>
                                <input type="number" value="${el.qtd}" class="form-control" disabled>

                                <span class="input-group-text">Produto</span>
                                <input type="text" class="form-control w-px-200" value="${el.nome}" disabled>

                                <span class="input-group-text">Precificação</span>
                                <input type="text" class="form-control w-px-200" value="${precificicao_info}" disabled>
                            </div>
                        </div>
                    </div>
                `;
            });

            // Irá contar quantos orçamentos editados já foram realizados
            
            try {
                countHistoryBudget(id).then(qtd => { 
                    $('#count-history-budget').text(qtd)
                })

                const cards = addCardsDialog(getDialogs(id));
    
                $('#cards-dialog-view-budget').html(cards)
            } catch (error) {
                console.log(error);
                console.log('Erro ao contar os orçamentos editados');
            }

            $('#render-info-products').html(html_product);

            $('#modal-view-id-budget').val(id);
            $('#modal-view-budget-display').text(id);
            $('#modal-view-cliente').val(data.orcamento_info.nome);
            $('#modal-view-dialogo').val(data.orcamento_info.dialogo);
            $('#modal-view-pessoa-contato').val(data.orcamento_info.pessoa_contato);
            $('#modal-view-data-orcado').val(data.orcamento_info.create_at);
            $('#modal-view-data-retorno').val(data.orcamento_info.data_retorno);
            $('#modal-view-valor-total').val(data.orcamento_info.valor_total)
            $('#modal-view-valor-entrada').val(data.orcamento_info.entrada_pgto)
            $('#modal-view-tipo-frete').val(data.orcamento_info.frete_tipo)
            $('#modal-view-prazo-entrega').val(data.orcamento_info.prazo_entrega)
            $('#modal-view-observacao-pedido').val(data.orcamento_info.observacao_pedido);
            $('#modal-view-pdf-budget-after').attr('data-source-pdf', data.orcamento_info.file);
            $('#modal-view-taxa-juros').val(`${data.orcamento_info.vezes_juros}`)
            $('button').prop('disabled', false);
            $('#loserBudget').val(id);
            $('#modal-view-budget').modal('show');
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });
}