const path_core = '../app/Core/';

function updateCosts() {
    const id = $('#costs-id').val();
    const impostoValorAnterior = $('#input-imposto-old-value').val()
    const imposto = $('#input-imposto').val()
    const custoAdmValorAnterior = $('#input-adm-old-value').val();
    const custoAdm = $('#input-adm').val();
    const comissaoValorAnterior = $('#input-comissao-old-value').val();
    const comissao = $('#input-comissao').val();
    const desconfoFinanceiro = $('#input-desconto').val();
    const desconfoFinanceiroValorAnterior = $('#input-desconto-old-value').val();

    const imposto2ValorAnterior = $('#input-imposto2-old-value').val();
    const imposto2 = $('#input-imposto2').val();
    const comissao2ValorAnterior = $('#input-comissao2-old-value').val();
    const comissao2 = $('#input-comissao2').val();

    const inputs = [imposto, custoAdm, comissao, desconfoFinanceiro, imposto2, comissao2];

    if(!isValidCosts(inputs)) return;

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Costs.php`,
        data: {
            id : id,
            action : 'update',

            // H1
            impostoValorAnterior: impostoValorAnterior,
            imposto : imposto,
            custoAdmValorAnterior: custoAdmValorAnterior,
            custoAdm : custoAdm,
            comissaoValorAnterior: comissaoValorAnterior,
            comissao : comissao,
            desconfoFinanceiroValorAnterior: desconfoFinanceiroValorAnterior,
            desconfoFinanceiro : desconfoFinanceiro,

            // H2
            imposto2ValorAnterior: imposto2ValorAnterior,
            imposto2 : imposto2,
            comissao2ValorAnterior: comissao2ValorAnterior,
            comissao2 : comissao2
        },
        success: function (data) {
            console.log(data);

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Taxa atualizada com sucesso!',
                timer: 3000
            });

            setTimeout(function () {
                window.location.reload();
            }, 500);

        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';

            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function calculaCustos() {
    const imposto 		= validateInput($('#input-imposto').val());
    const adminstrativo = validateInput($('#input-adm').val());
    const comissao 		= validateInput($('#input-comissao').val());
    const desconto		= validateInput($('#input-desconto').val());

    const resultado =  100 - ((Math.floor(imposto * 100) / 100) +
                                (Math.floor(adminstrativo  * 100) / 100) +
                                (Math.floor(comissao * 100) / 100) +
                                (Math.floor(desconto * 100) / 100));

    $('#txt-resultado').text(
        (resultado < 0) ? (0).toFixed(2) : (resultado).toFixed(2)
    );

    const imposto2 = validateInput($('#input-imposto2').val());
    const comissao2 = validateInput($('#input-comissao2').val());

    const resultado2 = 100 - ((Math.floor(imposto2 * 100) / 100) + (Math.floor(comissao2 * 100) / 100));

    $('#txt-resultado2').text(resultado2.toFixed(2));
}

calculaCustos();

function validateInput(input) {
    if (isNaN(input) || !input) {
        return 0;
    }

    return parseFloat(input);
}

$('#input-imposto, #input-adm, #input-comissao, #input-desconto, #input-imposto2, #input-comissao2').on('keyup', calculaCustos);

function isValidCosts(inputs) {
    let taxPositive = true;
    $.each(inputs, function(index, input) {
        if (!input || input.length === 0 || input === "" || Number(input) < 0) {
            fat_alert({
                title: 'Campos obrigatórios',
                message: 'Por favor, preencha com apenas números inteiros positivos.',
                type: 'danger',
                timer: 2000
            });

            taxPositive = false;
            return false;
        }
    });

    return taxPositive;
}

function clearInputsCosts() {
    $('#input-imposto').val('0');
    $('#input-adm').val('0');
    $('#input-comissao').val('0');
    $('#input-desconto').val('0');
    $('#input-imposto2').val('0');
    $('#input-comissao2').val('0');
}

$('#btn-save-costs').on('click', updateCosts);
$('#btn-clear-costs').on('click', clearInputsCosts);