const path_core = '../app/Core/';

function renderDaysMonth(qtd) {
    let text = '',
        days = 0;

    if (qtd == 0 && qtd != '') {
        $('#labelRenderDays').text(
            `A Vista.`
        );

        return;
    }

    if (qtd > 24) {
        days = Math.trunc(qtd * 30.4375).toLocaleString('pt-BR');

        $('#labelRenderDays').text(
            `Em ${qtd} meses, ${days} dias.`
        );
        return;
    }

    for (let i = 0; i < qtd; i++) {
        if (qtd == 1) {
            text = '30 dias.';
            break;
        }

        days += 30;
        text += `${days}/`;
    }

    $('#labelRenderDays').text(
        text.slice(0, -1)
    );
}

function store() {
    const vezes = parseInt($('#qtd-modal-create-fees').val());
    const juros = parseFloat($('#vezes-modal-create-fees').val());
    console.log(typeof vezes)

    const inputs = [vezes, juros];

    if(!requiredInputsFees(inputs)) return;

    $('#btn-add-fees').addClass('disabled');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Fees.php`,
        data: {
            action: 'store',
            juros: juros,
            vezes: vezes
        },
        success: function (data) {
            $('#modal-new-fees').modal('hide');

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Taxa cadastrada com sucesso!',
                timer: 3000,
                callback: function () {
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                }
            });
        },
        error: function (xhr) {
            $('#btn-add-fees').removeClass('disabled');
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function openModalUpdateFees(id) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Fees.php`,
        data: {
            action: 'getFees',
            idFees: id
        },
        success: function (data) {
            console.log(data);
            $('#id-modal-edit-fees').val(data.id);
            $('#juros-old-value').val(data.juros);
            $('#vezes-old-value').val(data.vezes);
            $('#qtd-modal-edit-fees').val(data.vezes);

            $('#vezes-modal-edit-fees').val(data.juros);

            $('#modal-edit-fees').modal('show');
        },
        error: function (data) {
            console.log(data);
            defaultError(data);
        }
    });
}

function updateFees() {
    const id = $('#id-modal-edit-fees').val();
    const vezesValorAnterior = $('#vezes-old-value').val();
    const vezes = $('#qtd-modal-edit-fees').val();
    const jurosValorAnterior = $('#juros-old-value').val();
    const juros = $('#vezes-modal-edit-fees').val();

    const inputs = [vezes, juros];

    if (!isRequiredInputs(inputs)) return;

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Fees.php`,
        data: {
            id: id,
            vezesValorAnterior: vezesValorAnterior,
            vezes: vezes,
            jurosValorAnterior: jurosValorAnterior,
            juros: juros,
            action: 'update'
        },
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Taxa atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-edit-fees').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function openModalDeleteFees(id) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Fees.php`,
        data: {
            idFees: id,
            action: 'getFees'
        },
        success: function (data) {
            console.log(data);
            $('#modal-delete-fees-id').val(data.id);

            $('#modal-delete-fees').modal('show');
        },
        error: function (data) {
            console.log(data);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });
        }
    });
}

function deleteFees() {
    const id = $('#modal-delete-fees-id').val();

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Fees.php`,
        data: {
            idFees: id,
            action: 'delete'
        },
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Taxa excluída com sucesso!',
                timer: 3000
            });

            $('#modal-delete-fees').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function requiredInputsFees(inputs) {
    let inputNotNull = true;
    $.each(inputs, function (index, input) {
        if (input < 0 && input !== 0 || isNaN(input) || input === "") {
            fat_alert({
                title: 'Campos obrigatórios',
                message: 'Por favor, preencha todos os campos obrigatórios e insira apenas números positivos.',
                type: 'danger',
                timer: 2000
            });

            inputNotNull = false;
            return false;
        }
    });
    return inputNotNull;
}

$('#btn-add-fees').on('click', store);
$('#btn-edit-fees').on('click', updateFees);
$('#btn-modal-delete-fees').on('click', deleteFees);