const path_core = '../app/Core/';

var update = 0;

function cadastraProduto() {

    // const codigoProduto = $('#modal-create-product-codigo').val().trim();
    const nome = $('#modal-create-product-name').val().trim();
    const descricao = $('#modal-create-product-descricao').val().trim();
    const obs = $('#modal-create-product-obs').val().trim();
    const frete = parseFloat($('#modal-create-product-frete').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-frete').maskMoney('unmasked')[0]) : '0.00';
    const freteRegra = $('#modal-create-product-regra-frete-compra').val(); 
    const categoria = $('#modal-create-product-categoria').val();

    const embalagem = parseFloat($('#modal-create-product-embalagem').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-embalagem').maskMoney('unmasked')[0]) : '0.00';
    const embalagemRegra = $('#modal-create-product-regra-embalagem').val();

    const maoDeObra = parseFloat($('#modal-create-product-mao-obra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-mao-obra').maskMoney('unmasked')[0]) : '0.00';
    const maoDeObraRegra = parseFloat($('#modal-create-product-regra-mao-obra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-regra-mao-obra').maskMoney('unmasked')[0]) : '0.00';

    const extra = parseFloat($('#modal-create-product-extra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-extra').maskMoney('unmasked')[0]) : '0.00';
    const valUnitCusto = parseFloat($('#modal-create-product-valor-compra-un-custo').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-create-product-valor-compra-un-custo').maskMoney('unmasked')[0]) : '0.00';
    const fotos = $('#modal-create-product-photo')[0].files;
    let data = new FormData();

    const inputs = [nome, frete, embalagem, maoDeObra, extra, valUnitCusto]

    if (!valideteSizeByTagId($('#modal-create-product-photo'), (20 * 1024 * 1024))) return;
    if (!isRequiredInputs(inputs)) return;

    if (maoDeObraRegra == 0) {
        fat_alert({
            type: 'error',
            title: 'Oops!',
            message: 'Regra de mão de obra é um campo obrigatório!',
            timer: 3000
        });
        return;
    }

    if (!categoria) {
        fat_alert({
            type: 'error',
            title: 'Oops!',
            message: 'Categoria é um campo obrigatório!',
            timer: 3000
        });
        return;
    }

    // data.append('codigoProduto', codigoProduto);
    data.append('nome', nome);
    data.append('categoria', categoria);
    data.append('descricao', descricao);
    data.append('observacao', obs);
    data.append('frete', frete);
    data.append('freteRegra', freteRegra);
    data.append('embalagem', embalagem);
    data.append('embalagemRegra', embalagemRegra);
    data.append('maoDeObra', maoDeObra);
    data.append('maoDeObraRegra', maoDeObraRegra);
    data.append('extra', extra);
    data.append('valUnitCusto', valUnitCusto);

    $.each(fotos, function (index, image) {
        data.append('fotos[]', image);
    });

    data.append('action', 'store');

    $('#btn-add-new-product').attr('disabled', true);
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Product.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Produto cadastrado com sucesso!',
                timer: 3000
            });

            update = 1;

            const continuarCadastrando = $('#modal-create-product-continuar-cadastrando').is(':checked') ? 1 : 0;
            if (continuarCadastrando === 1) {
                // necessidade de criar uma única classe para resetar tudo de uma vez
                // $('#modal-create-product-codigo').val('');
                $('#modal-create-product-name').val('');
                $('#modal-create-product-descricao').val('');
                $('#modal-create-product-frete').val('');
                $('#modal-create-product-embalagem').val('');
                $('#modal-create-product-mao-obra').val('');
                $('#modal-create-product-extra').val('');
                $('#modal-create-product-valor-compra-un-custo').val('');
                $('#modal-create-product-photo').val('');

                return;
            }

            setTimeout(() => {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        },
        complete: function() {
            $('#btn-add-new-product').attr('disabled', false);
        }
    });
}

reloadProductList();

var deleted_product_image = [];

function showModalEditProduct(id) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Product.php`,
        data: {
            action: 'getProductData',
            productId: id
        },
        success: function (data) {
            console.log(data);
            $('#modal-edit-product-id').val(id);
            $('#modal-edit-product-categoria').val(data.info.id_codigo_FK).trigger('change');
            $('#modal-edit-product-name').val(data.info.nome);
            $('#modal-edit-product-descricao').val(data.info.descricao);
            $('#modal-edit-product-obs').val(data.info.observacao);
            $('#modal-edit-product-frete').val(data.info.frete_compra);
            $('#modal-edit-product-regra-frete-compra').val(data.info.frete_compra_regra);
            $('#modal-edit-product-embalagem').val(data.info.embalagem);
            $('#modal-edit-product-regra-embalagem').val(data.info.embalagem_regra)
            $('#modal-edit-product-mao-obra').val(data.info.mao_obra);
            $('#modal-edit-product-regra-mao-obra').val(data.info.mao_obra_regra);
            $('#modal-edit-product-extra').val(data.info.extras);
            $('#modal-edit-product-valor-compra-un-custo').val(data.info.valor_compra);

            const uploadImgWrap = $('#upload-img-wrap');
            uploadImgWrap.empty();

            for (let i = 0; i < data.fotos.length; i++) {
                const imageId = data.fotos[i].id;
                const imageUrl = data.fotos[i].produto_foto;
                const imgBox = $('<div>').addClass('upload__img-box');
                const imgBg = $('<div>').addClass('img-bg rounded-3').css('background-image', 'url("assets/file/product/' + imageUrl + '")');
                const imgClose = $('<div>').addClass('upload__img-close');

                imgBg.attr('data-number', $('.upload__img-close').length);
                imgBg.attr('data-file', imageUrl);
                imgBg.attr('data-id', imageId);

                imgBg.append(imgClose);
                imgBox.append(imgBg);
                uploadImgWrap.append(imgBox);
            }

            $(".upload__img-close").on('click', function (e) {
                const imageId = $(this).parent().attr('data-id');
                deleted_product_image.push(imageId);
                $(this).parent().parent().remove();
            });

            $('#modal-edit-product').modal('show');
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
        }
    });
}

function updateProduct() {
    const idImages = deleted_product_image;
    const id = $('#modal-edit-product-id').val().trim();
    // const codigoProduto = $('#modal-edit-product-codigo').val().trim();
    const nome = $('#modal-edit-product-name').val().trim();
    const categoria = $('#modal-edit-product-categoria').val();
    const descricao = $('#modal-edit-product-descricao').val().trim();
    const obs = $('#modal-edit-product-obs').val().trim();

    const frete = parseFloat($('#modal-edit-product-frete').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-edit-product-frete').maskMoney('unmasked')[0]) : '0.00';
    const freteRegra = $('#modal-edit-product-regra-frete-compra').val(); 

    const embalagem = parseFloat($('#modal-edit-product-embalagem').maskMoney('unmasked')[0]) !== 0 ?  parseFloat($('#modal-edit-product-embalagem').maskMoney('unmasked')[0]) : '0.00';
    const embalagemRegra = $('#modal-edit-product-regra-embalagem').val();

    const maoDeObra = parseFloat($('#modal-edit-product-mao-obra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-edit-product-mao-obra').maskMoney('unmasked')[0]) : '0.00';
    const maoDeObraRegra = parseFloat($('#modal-edit-product-regra-mao-obra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-edit-product-regra-mao-obra').maskMoney('unmasked')[0]) : '0.00';

    const extra = parseFloat($('#modal-edit-product-extra').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-edit-product-extra').maskMoney('unmasked')[0]) : '0.00';
    const valUnitCusto = parseFloat($('#modal-edit-product-valor-compra-un-custo').maskMoney('unmasked')[0]) !== 0 ? parseFloat($('#modal-edit-product-valor-compra-un-custo').maskMoney('unmasked')[0]) : '0.00';
    const fotos = $('#modal-edit-product-photo')[0].files;
    let data = new FormData();

    const inputs = [nome, frete, embalagem, maoDeObra, extra, valUnitCusto]

    if (!isRequiredInputs(inputs)) return;
    if (!valideteSizeByTagId($('#modal-edit-product-photo'), (5 * 1024 * 1024))) return;

    if (maoDeObraRegra == 0) {
        fat_alert({
            type: 'error',
            title: 'Oops!',
            message: 'Regra de mão de obra é um campo obrigatório!',
            timer: 3000
        });
        return;
    }

    if (!categoria) {
        fat_alert({
            type: 'error',
            title: 'Oops!',
            message: 'Categoria é um campo obrigatório!',
            timer: 3000
        });
        return;
    }

    data.append('idImages[]', idImages);
    data.append('id', id);
    // data.append('codigoProduto', codigoProduto);
    data.append('nome', nome);
    data.append('categoria', categoria);
    data.append('descricao', descricao);
    data.append('observacao', obs);

    data.append('frete', frete);
    data.append('freteRegra', freteRegra);

    data.append('embalagem', embalagem);
    data.append('embalagemRegra', embalagemRegra);

    data.append('maoDeObra', maoDeObra);
    data.append('maoDeObraRegra', maoDeObraRegra);

    data.append('extra', extra);
    data.append('valUnitCusto', valUnitCusto);

    $.each(fotos, function (index, image) {
        data.append('fotos[]', image);
    });

    data.append('action', 'update');

    $('#btn-edit-product').attr('disabled', true);
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Product.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            $(`td[data-td-product-nome='${id}']`).html(data.nome);
            $(`td[data-td-product-descricao='${id}']`).html(data.descricao);
            $(`td[data-td-product-pontuacao='${id}']`).html(data.pontuacao);
            if (data.img_name != '') {
                $(`td[data-td-product-img='${id}']`).html(`<img src="assets/file/product/${data.img_name}" onerror='this.src="assets/file/system/undraw_profile.svg"' class='img-render rounded-circle' alt="#"> `);
            }

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Produto atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-edit-product').modal('hide');

            setTimeout(() => {
                window.location.reload();
            }, 500);

            deleted_product_image = [];
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        },
        complete: function() {
            $('#btn-edit-product').attr('disabled', false);
        }
    })
}

var selected_images = []; // Array para armazenar os arquivos selecionados
function ImgUpload() {
    let imgWrap = ""; // Variável para armazenar o elemento de envolvimento da imagem
    let imgArray = []; // Array para armazenar as imagens selecionadas
    selected_images = selected_images ? selected_images : [];
    let mergedArray = []; // Array para armazenar a mescla dos arrays imgArray e selected_images

    // Configuração do evento de mudança para o input de arquivo
    $('.upload__inputfile').off('change').on('change', function (e) {
        imgWrap = $(this).closest('.upload__box').find('.upload__img-wrap'); // Encontra o elemento que envolve a imagem
        const maxLength = $(this).attr('data-max_length'); // Obtém o comprimento máximo permitido das imagens

        let files = e.target.files; // Obtém os arquivos selecionados no input
        let filesArr = Array.prototype.slice.call(files); // Converte o objeto de arquivos em um array
        let iterator = 0;

        // Itera sobre cada arquivo selecionado
        filesArr.forEach(function (f, index) {
            if (!f.type.match('image.*')) {
                return; // Ignora arquivos que não são imagens
            }

            if (imgArray.length >= maxLength) {
                return false; // Se o número máximo de imagens for atingido, sai do loop
            }

            let len = 0;
            for (let i = 0; i < imgArray.length; i++) {
                if (imgArray[i] !== undefined) {
                    len++;
                }
            }

            if (len >= maxLength) {
                return false; // Se o número máximo de imagens for atingido, sai do loop
            }

            // Verifica se a imagem já existe no array
            let isDuplicate = false;
            console.log(imgArray)
            for (let i = 0; i < imgArray.length; i++) {
                if (imgArray[i].name === f.name && imgArray[i].size === f.size) {
                    isDuplicate = true;
                    break;
                }
            }

            if (isDuplicate) {
                return; // Se a imagem já existe, sai do loop
            }

            imgArray.push(f); // Adiciona a imagem ao array de imagens
            selected_images.push(f); // Adiciona o arquivo ao array de arquivos selecionados

            const reader = new FileReader();
            reader.onload = function (e) {
                // Cria o HTML para exibir a imagem e adiciona ao elemento de envolvimento
                let html = "<div class='upload__img-box'><div style='background-image: url(" + e.target.result + ")' data-number='" + $(".upload__img-close").length + "' data-file='" + f.name + "' class='img-bg rounded-3'><div class='upload__img-close'></div></div></div>";
                imgWrap.append(html);
                iterator++;
            }
            reader.readAsDataURL(f); // Lê o conteúdo da imagem como URL de dados
        });

        mergedArray = imgArray.concat(selected_images); // Mescla os arrays imgArray e selected_images no mergedArray

        for (let i = 0; i < mergedArray.length - 1; i++) {
            const currentElement = mergedArray[i];

            for (let j = i + 1; j < mergedArray.length; j++) {
                const nextElement = mergedArray[j];

                // Realiza a comparação das propriedades relevantes para determinar se os objetos são iguais
                if (currentElement.id === nextElement.id && currentElement.name === nextElement.name) {
                    mergedArray.splice(j, 1); // Remove o elemento duplicado do mergedArray
                    j--; // Decrementa o contador j para ajustar o índice após a remoção
                }
            }
        }

        // Atualiza o objeto files do input após adicionar as imagens
        const updatedFiles = new DataTransfer();
        for (let i = 0; i < mergedArray.length; i++) {
            updatedFiles.items.add(mergedArray[i]);
        }

        $(this)[0].files = updatedFiles.files;

        // Use o array mergedArray conforme necessário
        console.log(mergedArray);
    });

    // Configuração do evento de clique no botão de fechar da imagem
    $('body').on('click', ".upload__img-close", function (e) {
        const file = $(this).parent().data("file"); // Obtém o nome do arquivo associado à imagem
        for (let i = 0; i < mergedArray.length; i++) {
            if (mergedArray[i].name === file) {
                mergedArray.splice(i, 1); // Remove a imagem do array de imagens
                break;
            }
        }
        $(this).parent().parent().remove(); // Remove o elemento da imagem do DOM

        // Atualiza o objeto files do input após remover a imagem
        const inputFiles = $('.upload__inputfile')[0].files;
        const updatedFiles = new DataTransfer();
        for (let i = 0; i < inputFiles.length; i++) {
            if (inputFiles[i].name !== file) {
                updatedFiles.items.add(inputFiles[i]);
            }
        }
        $('.upload__inputfile')[0].files = updatedFiles.files;
        selected_images = Array.from(updatedFiles.files); // Converte para array e atualiza a variável selected_images
    });
}

function modalShowDeleteProduct(id, name, status) {
    $('#modal-delete-product-title').html('Excluir produto');
    $('#modal-delete-product-message').html('Você quer realmente excluir o produto <b>' + name + '</b>?');

    $('#modal-delete-product-id').val(id);
    $('#modal-delete-product-current-status').val(status);
    $('#modal-delete-product-name-product').val(name);

    $('#modal-delete-product').modal('show');
}

function deleteProduct() {
    const id = $('#modal-delete-product-id').val();
    const status = $('#modal-delete-product-current-status').val();

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Product.php`,
        data: {
            action: 'deleteProduct',
            id: id,
            status: status
        },
        success: function (data) {
            console.log(data)

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Status atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-delete-product').modal('hide')

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function reloadProductList() {
    if (update === 0) return;

    function reloadPage() {
        setTimeout(() => {
            window.location.reload();
        }, 500);
    }

    $(document).on('hidden.bs.modal', '#modal-new-product', function () {
        reloadPage();
    });
}

setTimeout(() => {
    $(".real").maskMoney({
        prefix: 'R$ ',
        thousands: '.',
        decimal: ','
    })
}, 500);

$('#btn-add-new-product').on('click', cadastraProduto);
$('#btn-edit-product').on('click', updateProduct);
$(".upload__inputfile").on('click', ImgUpload)
$("#btn-modal-delete-product").on('click', deleteProduct)



const btnFilterProduct = $('#btn-filter-product');
const textFilterProduct = $('#text-filter-product');

textFilterProduct.keypress(function(event) {
    if (event.which === 13) {

        filterProduct();
    }
});

function filterProduct() {
    const text = textFilterProduct.val();
    let currentURL = window.location.href;

    // Remove o parâmetro "page" se existir
    currentURL = currentURL.replace(/(\?|&)page=[^&]*/, '');
    currentURL = currentURL.replace(/[?&]$/, '');

    currentURL = currentURL.replace(/(\?|&)filter=[^&]*/, ''); // Remove o parâmetro "filter" da URL
    currentURL = currentURL.replace(/[?&]$/, '');

    // Defina o parâmetro "page" como 1
    currentURL = currentURL + (currentURL.includes('?') ? '&' : '?') + 'page=1';
    
    if (!text) {
        window.location.href = currentURL;
        return;
    }

    // Verifica se a URL já contém o parâmetro "filter"
    if (currentURL.includes("filter=")) {
        // Se o parâmetro "filter" já existe, você pode substituir o valor. Por exemplo, vamos definir o novo valor como "novofiltro".
        currentURL = currentURL.replace(/(filter=)[^\&]+/, `filter=${text}`);
    } else {
        // Se o parâmetro "filter" não existe, você pode adicioná-lo à URL. Por exemplo, vamos adicionar o parâmetro "filter" com o valor "novofiltro".
        if (currentURL.includes("?")) {
            currentURL += `&filter=${text}`;
        } else {
            currentURL += `?filter=${text}`;
        }
    }

    // Define a nova URL com o parâmetro "page" igual a 1

    // Redirecione para a nova URL
    window.location.href = currentURL;
}


btnFilterProduct.on('click', filterProduct);