var ini_point = 0;
var ini_value = 0;

var ini_point_campaign = 0;
var ini_value_campaign = 0;

if ($('#table_sale').length) {
   var userTable = $('#table_sale').DataTable({
        dom: 'Brtip',
        buttons: [
            {
                text: 'Nova venda',
                action: function (e, dt, node, config) {
                    openModalSale();
                }
            },
            'colvis',
            {
                extend: 'collection',
                text: 'Exportar',
                buttons: ['copyHtml5', 'csvHtml5', 'pdfHtml5', {
                    text: 'Excel',
                    action: function () {
                        TableToExcel.convert(document.querySelector("#table_sale"), {
                            name: `SoftDoc - Usuários - ${new Date().toLocaleString()}.xlsx`
                        });
                    }
                }],
            },
        ],
        "oLanguage": {
            "sUrl": "assets/vendor/dataTable/pt-BR.json"
        }
   });
}

function openModalSale() {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Sale.php`,
        data: {action: 'preparedModalStore'},
        success: function (data) {

            console.log(data);
            let html_user, html_campaing = '<option value="">Nenhum selecionado</option>';

            ini_point = data.point[0].pontos;
            ini_value = data.point[0].valor;
            $('#modal-input-new-sale-view-point-id').val(data.point[0].id);

            data.users.forEach(el => {
                html_user += `<option value="${el.id}">${el.nome} - ${el.email} - ${getNivelById(el.nivel)}</option>`;
            });

            data.campaigns.forEach(el => {
                html_campaing += `<option data-campaign-ponto="${el.pontos}" data-campaign-valor="${el.valor}" value="${el.id}">${el.nome} - A cada R$ ${el.valor} gastos, ganhará ${el.pontos} ponto(s)</option>`;
            });

            $('#data-users-sales').empty().append(html_user).trigger('change');            
            $('#data-campaing-sales').empty().append(html_campaing).trigger('change');
            $('#modal-new-sale').modal('show')
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
            return false;
        }
    });
}

function selectedCampaing(id) {

    ini_point_campaign = parseFloat($(`#data-campaing-sales > option[value="${id}"]`).attr('data-campaign-ponto'));
    ini_value_campaign = parseFloat($(`#data-campaing-sales > option[value="${id}"]`).attr('data-campaign-valor'));

    if (!id ) {
        $('#render-value-insert-campaing').addClass('d-none');
        return;
    }

    $('#render-value-insert-campaing').removeClass('d-none');
}

function cadastraNovaVenda() {
    const pedido = $('#modal-new-sale-pedido').val();
    const conf_pontos = $('#modal-input-new-sale-view-point-id').val();
    const pontos = $('#modal-input-new-sale-view-point').val();
    const descricao = $('#modal-new-sale-descricao').val();
    const usuarios = $('#data-users-sales').val();
    const valor = $('#modal-input-value-sale-mask').maskMoney('unmasked')[0];
    const data = $('#modal-new-sale-data-compra').val();

    const values = {
        action : 'store',
        pedido : pedido,
        pontos : pontos,
        conf_pontos: conf_pontos,
        descricao : descricao ?? '',
        usuarios : usuarios,
        valor: valor,
        data: data
    };

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Sale.php`,
        data: values,
        beforeSend: function() {
            $('#btn-new-sale').addClass('disabled');
        },
        success: function (data) {

            console.log(data);
            Swal.fire(
                'Sucesso!',
                'Cadastrado com sucesso!',
                'success'
            );

            $('#modal-new-sale').modal('hide');
            window.location.reload = true;
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
            return false;
        },
        complete: function() {
            $('input').val('');
            $('#btn-new-sale').removeClass('disabled');
        }
    })
}

$('#btn-new-sale').on('click', cadastraNovaVenda);

setTimeout(() => {
    $(".real").maskMoney({
        prefix:'R$ ', 
        thousands:'.', 
        decimal:','
    })
}, 500);

$(document).ready(function() {
    $('.select2-multiple').select2();
});

$('#modal-input-divide-users, #data-users-sales').on('change', function() {
    changeViewPoint();
});

function changeViewPoint() {
    // Futuramente deverá gravar na base somente o calculo do back-end
    const valor = Math.floor($('#modal-input-value-sale-mask').maskMoney('unmasked')[0]);

    if ($('#modal-input-divide-users:checked').val()) {
        const pessoas = $('#data-users-sales').val().length;
        const result = ((valor / ini_value) * ini_point) / pessoas;
        $('#modal-input-new-sale-view-point').val(result);
        $('#modal-new-sale-view-point').text('Irá ganhar ' + result + ' pontos cada pessoa selecionada!');
        return;
    }

    const result = (valor / ini_value) * ini_point;
    $('#modal-input-new-sale-view-point').val(result);
    $('#modal-new-sale-view-point').text('Irá ganhar ' + result + ' pontos!');
}

function changeViewPointCampaign() {
    const valor = Math.floor($('#modal-input-value-sale-campaign-mask').maskMoney('unmasked')[0]);

    if ($('#modal-input-divide-users:checked').val()) {
        const pessoas = $('#data-users-sales').val().length;
        const result = ((valor / ini_value_campaign) * ini_point_campaign) / pessoas;
        $('#modal-input-new-sale-view-point-campaign').val(result.toFixed(2));
        $('#modal-new-sale-view-point-campaign').text('Irá ganhar ' + result.toFixed(2) + ' pontos cada pessoa selecionada!');
        return;
    }

    const result = (valor / ini_value_campaign) * ini_point_campaign;
    $('#modal-input-new-sale-view-point-campaign').val(result.toFixed(2));
    $('#modal-new-sale-view-point-campaign').text('Irá ganhar ' + result.toFixed(2) + ' pontos!');
}

// $('#btn-add-new-user').on('click', createUser);
// $('#btn-add-edit-user').on('click', updateUser);