const agroupment_id = document.getElementById('agroupmentParam').value;

var table = $('#table_id').DataTable({
    dom: 'BRfti', //lfrtip
    paging: false,
    scrollX: true,
    scrollCollapse: true,
    fixedHeader: {
        header: true,
        footer: true
    },
    colReorder: true,
    "oSearch": { "bSmart": false, "bRegex": true },
    buttons: [
        {
            text: '<i class="fa-solid fa-plus"></i> Novo item',
            action: function (e, dt, node, config) {
                loadInputs();
            },
        },
        // {
        //     text: '<i class="fa-solid fa-table-columns"></i> Nova coluna',
        //     action: function (e, dt, node, config) {
        //         $('#modal-new-column').removeClass('d-none');
        //         $('#modal-nome-new-column').val('');
        //         $('#modal-descricao-new-column').val('');
        //         $('#modal-tipo-new-column').val('');

        //         $('#modal-new-column').modal('show');
        //     }
        // },
        // {
        //     text: '<i class="fa-solid fa-layer-group"></i> Novo agrupamento',
        //     action: function (e, dt, node, config) {
        //         configNewAgroupment();
        //     },
        // },
        // {
        //     text: '<i class="fa-solid fa-chart-column"></i> Movimentação',
        //     action: function () {
        //         configNewMov();
        //     }
        // },
        {
            extend: 'colvis',
            collectionLayout: 'fixed columns',
            collectionTitle: 'Selecione para ocultar/visualizar',
            postfixButtons: [
                {
                    extend: 'colvisRestore',
                    text: 'Mostrar todos',
                },
                {
                    extend: 'colvisGroup',
                    text: 'Ocultar todos',
                    hide: ':visible'
                }
            ]
        },
        {
            extend: 'collection',
            text: '<i class="fa-solid fa-download"></i> Exportar',
            buttons: ['copyHtml5', 'csvHtml5', 'pdfHtml5', {
                text: 'Excel',
                action: function () {
                    generateExcel();
                }
            }],
        }
    ],
    "oLanguage": {
        "sUrl": "../assets/vendor/dataTable/pt-BR.json"
    }
});

const count_columns = $("#names_filter th").length;
let iterator = 0;
$("#names_filter th").each(function () {
    iterator++;
    var title = $(this).text();

    if (iterator == count_columns) {
        $(this).html('<button class="btn btn-sm btn-outline-secondary" onclick="resetFilters()" type="button">Limpar filtros</button>');
        return;
    }

    $(this).html('<input type="text" data-input-search placeholder="Filtrar ' + title + '" />');
});

function resetFilters() {
    $('input[data-input-search]').val('');
    table.search('').columns().search('').draw()
}

setTimeout(() => {
    table.columns().every(function (index) {
        let that = this;

        $("input[data-input-search]", this.footer()).on("keyup change clear", function () {
            if (that.search() !== this.value) {
                that.search(this.value).draw();
                calculateColumns().then(resultado => {
                    console.info(`Promise search: Calculo finalizado (load)`);
                }).catch(erro => {
                    console.error(`Erro ao calcular: ${erro} (load)`);
                });
            }
        });
    });
}, 300);

setTimeout(() => {
    const btns = $('.dt-button');
    btns.addClass('btn btn-outline-secondary btn-sm');
    btns.removeClass('dt-button');
}, 50);

const num_columns = $('th[data-th-index-number]').length
/**
 * Método responsável por realizar cálculo no eixo y dos campos números e de ponto flutuante
 * @return Promise 
 */
function calculateColumns() {

    const elements = $('th[data-id-column]');
    let idColumns = [];

    elements.each(function() {
        let idColumn = $(this).attr('data-id-column');
        idColumns.push(idColumn);
    });


    return new Promise((resolve, reject) => {

        idColumns.forEach(i => {
            value_column = 0;

            $(`td[data-column-number='${i}']`).each(function (j, el) {
                let data = parseFloat($(this).attr('data-column-value'));

                if (isAllNumbers(data)) {
                    value_column += data;
                }
            });

            if (!isAllNumbers(value_column) || value_column == 0) {
                value_column = '';
            }

            
            value_finish = isAllNumbers(value_column) ? '<small>Total: </small> <strong>' + numberToBRLvalue(value_column) + '</strong>' : '';
            console.log(value_finish);
            $(`td[data-column-index-tfoot='${i}']`).html(value_finish);
        });

        // for (let i = 0; i <= num_columns; i++) {
        //     value_column = 0;

        //     $(`td[data-column-number='${i}']`).each(function (j, el) {
        //         let data = parseFloat($(this).attr('data-column-value'));

        //         if (isAllNumbers(data)) {
        //             value_column += data;
        //         }
        //     });

        //     if (!isAllNumbers(value_column) || value_column == 0) {
        //         value_column = '';
        //     }

        //     value_finish = isAllNumbers(value_column) ? '<small>Total: </small> <strong>' + numberToBRLvalue(value_column) + '</strong>' : '';
        //     $(`td[data-column-index-tfoot='${i - 1}']`).html(value_finish);
        // }

        $('th[data-button-index-option]').click();
        resolve('calculado');
    });
}

function generateExcel() {
    TableToExcel.convert(document.querySelector("#table_id"), {
        name: `SoftDoc - ${new Date().toLocaleString()}.xlsx`
    });
}

function calculateMovements() {
    let tbls = [];
    let columns = [];

    $('td[data-mov-tbl]').each(function () {
        tbls.push($(this).attr('data-mov-tbl'));
    });

    $('td[data-column-mov-name]').each(function () {
        columns.push($(this).attr('data-column-mov-name'));
    });
    
    const tbls_unique = tbls.filter(onlyUnique);
    const columns_unique = columns.filter(onlyUnique);

    tbls_unique.forEach(base => {
        let values = [];

        $.ajax({
            async: false,
            type: 'POST',
            dataType: 'JSON',
            url: '../assets/backend/Movement.php',
            data: {
                action: 'getDataMovementCalcJSON',
                table: base
            },
            success: function (data) {
                values = data;
            },
            error: function (xhr) {
                console.log(xhr);
            }
        });

        values.forEach(el => {
            columns_unique.forEach(col => {

                html_current = $(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).html();
                html_current = html_current.split('R$');
                html_current = html_current[0];

                if (isRealValue(el[col])) {
                    current = toDollar($(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).text());

                    result = formatter.format(
                        parseFloat(current) + parseFloat(toDollar(el[col]))
                    );

                    $(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).html(`${html_current} ${result}`);
                    $(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).attr('data-column-value', sanitizeValueBr(result));
                }

                if (isNumber(el[col])) {
                    current = parseInt($(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).text());
                    result = (!isNumber(current) ? 0 : current) + parseInt(el[col]);

                    $(`td[data-column-mov-name="${col}"]`).filter(`td[data-mov-group="${el.id_group_FK}"]`).html(`${html_current} ${result}`);
                }
            });
        });
    });

    $('td[data-mov-item]').on('click', dataMovement);

    calculateColumns().then(resultado => {
        console.info(`Promise search: Calculo finalizado (load)`);
    }).catch(erro => {
        console.error(`Erro ao calcular: ${erro} (load)`);
    });
}

calculateMovements();

function loadInputs() {
    const data_ajax = agroupment_id ? {
        action: "getColumnsAgroupment",
        id: agroupment_id
    } : {
        action: "getColumns"
    };

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Column.php',
        data: data_ajax,
        success: function (data) {

            console.log(data);

            let html = '<div class="row">';

            for (const [key, e] of Object.entries(data)) {

                html += '<div class="form-group col-xl-4 col-lg-4 col-sm-12 col-xs-12">';
                html += `<label>${e[0].name}</label>`;
                data_name = `data-doc-name="${e[0].name}"`;

                if (e[0].type == 10) {
                    html += `
                        <select ${data_name} name="${e[0].id}-10" items-doc-input-create class="form-control items-doc-input-create">
                        <option value="">Nenhum selecionado</option>
                    `;
                }

                e.forEach((el, i) => {

                    disabled = el.isMoviment == 1 ? 'disabled placeholder="Campo bloqueado (movimentação)"' : '';

                    switch (el.type) {
                        case 1:
                            // Int
                            html += `<input ${disabled} type="number" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-create">`
                            break;
                        case 2:
                            // Text
                            html += `<input ${disabled} type="text" ${data_name} maxlength="100" name="${el.id}-${el.type}" class="form-control items-doc-input-create">`
                            break;
                        case 3:
                            // Money - Real
                            html += `<input ${disabled} type="text" ${data_name} maxlength="100" name="${el.id}-${el.type}" class="form-control items-doc-input-create" data-mask-money placeholder="R$ 0,00">`
                            break;
                        case 4:
                            // Long Text
                            html += `<textarea ${disabled} ${data_name} rows="1" name="${el.id}-${el.type}" class="form-control items-doc-input-create"></textarea>`
                            break;
                        case 5:
                            // Date
                            html += `<input ${disabled} type="date" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-create">`
                            break;
                        case 6:
                            // Date Time
                            html += `<input ${disabled} type="datetime-local" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-create">`
                            break;
                        case 7:
                            // Image
                            html += `<input ${disabled} type="file" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-create" accept="image/*" data-image-input>`;
                            break;
                        case 8:
                            // All files
                            html += `<input ${disabled} type="file" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-create" data-file-input>`;
                            break;
                        case 9:
                            // Implements
                            break;
                        case 10:
                            // Options
                            html += `<option ${disabled} value="${e[i][key + '_id']}">${e[i][key + '_id']} - ${e[i][key + '_name']}</option>`;
                            break;
                        default:
                            console.error('contate o administrador');
                            break;
                    }

                });

                if (e[0].type == 10) {
                    html += `</select>`;
                }

                html += '</div>';
            }

            html += '</div>';

            $('#modal-body-add-new-line').html(html);
            $('#modal-new-line').modal('show');

            activeMaskMoney();
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
            console.log('falha no carregamento dos itens');
            return false;
        }
    });
}

$('#btn-save-item-add').on('click', function () {
    const form_data = $('#modal-body-add-new-line').serializeArray();
    const max_file_size = 20 * 1024 * 1024; // 20MB em Bytes
    const files_img_count = $('input[data-image-input]').length;
    const files_count = $('input[data-file-input]').length;

    let data = new FormData();
    let count_limit = 0;

    $.each(form_data, function (key, input) {
        data.append(input.name, input.value);
    });

    for (var i = 0; i < files_img_count; i++) {
        if (typeof $('input[data-image-input]')[i].files[0] === 'undefined') {
            continue;
        }

        data.append(
            $('input[data-image-input]')[i].name,
            $('input[data-image-input]')[i].files[0]
        );

        count_limit += $('input[data-image-input]')[i].files[0].size ?? 0;
    }

    for (let i = 0; i < files_count; i++) {
        if (typeof $('input[data-file-input]')[i].files[0] === 'undefined') {
            continue;
        }

        data.append(
            $('input[data-file-input]')[i].name,
            $('input[data-file-input]')[i].files[0]
        );

        count_limit += $('input[data-file-input]')[i].files[0].size ?? 0;
    }

    if (count_limit > max_file_size) {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: `A soma de imagens e arquivos não podem ultrapassar ${(max_file_size / 1024 / 1024)}MB`,
            footer: '<a href="mailto:suporte@fattos.com.br">Notou algo de errado? Entre em contato!</a>'
        });

        return;
    }

    data.append('action', 'store');

    $('#btn-save-item-add').prop('disabled', true);
    $('#btn-save-item-add').addClass('c-n');
    $('.sppiner-button-add').removeClass('d-none');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Info.php',
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            // console.log(data); return;
            $('#btn-save-item-add').prop('disabled', false);
            $('#btn-save-item-add').removeClass('c-n');
            $('.sppiner-button-add').addClass('d-none');
            $('input').val('');

            Swal.fire(
                'Sucesso!',
                'Novo item cadastrado com sucesso!',
                'success'
            );

            update = 1;

            $('#modal-new-line').modal('hide');
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
            return false;
        }
    });
});

$('button[data-button-show-image]').on('click', function (e) {
    let html = '';

    if (isPdf($(this).val())) {
        html += `<object class="object-doc" data="../assets/file/data/${$(this).val()}" type="application/pdf">`;
        html += `    <iframe class="object-doc" src="../assets/file/data/${$(this).val()}"></iframe>`;
        html += '</object>';
    } else if (isImage($(this).val())) {
        html = `<img src="../assets/file/data/${$(this).val()}" onerror="this.onerror=null; this.src='../assets/file/system/default-image.svg'">`;
    } else {
        html = `<img src="../assets/file/system/default-image.svg" title="${$(this).val()}" style="width:100px"><br><label class="text-center">Arquivo do tipo <strong> .${getTypeFile($(this).val())}</strong></label>`;
    }

    $('#btn-download-file').prop('href', `../assets/file/data/${$(this).val()}`);

    $('#view-image-render').html(html);
    $('#modal-view-image').modal('show');
});

function showModalFileMovement() {
    let html = '';

    const type = $(this).attr('data-type-mov-file');

    switch (type) {
        case 'image':
            html = `<img src="../assets/file/movement/${$(this).val()}">`;
            break;
        case 'pdf':
            html += `<object class="object-doc" data="../assets/file/movement/${$(this).val()}" type="application/pdf">`;
            html += `    <iframe class="object-doc" src="../assets/file/movement/${$(this).val()}"></iframe>`;
            html += '</object>';
            break;
        case 'other':
            html = `<img src="../assets/file/system/default-image.svg" title="${$(this).val()}" style="width:100px"><br><label class="text-center">Arquivo do tipo <strong> .${getTypeFile($(this).val())}</strong></label>`;
            break;
        default:
            defaultError();
            return;
            break;
    }

    $('#btn-download-file').prop('href', `../assets/file/movement/${$(this).val()}`);
    $('#view-image-render').html(html);
    $('#modal-view-image').modal('show');
}

// $('button[data-button-show-image-movement]').on('click', showModalImageMovement);

function renderHtml(option) {
    let html = '';

    switch (option) {
        case 'new-categorie':
            html += '<div class="form-group">';
            html += '    <label>Opções <i class="fa-regular fa-circle-question" data-toggle="tooltip" data-placement="top" data-html="true" title="Exemplo abaixo<br><br>Nome da coluna: <strong>Fruta</strong><br>Opções: <strong>Banana</strong>, <strong>Maçã</strong>, <strong>Uva</strong>"></i></label>';
            html += '    <select class="form-control select2-dynamics-data-categories" id="dinamics-categories" multiple="multiple" >';
            html += '    </select>';
            html += '</div>';
            break;
        case 'new-movement':
            html += '<div class="form-group">';
            html += '    <label>Tipo de movimentação <i class="fa-regular fa-circle-question" data-toggle="tooltip" data-placement="top" data-html="true" title="Este campo irá se referir a soma das movimentações adicionadas"></i></label>';
            html += '    <select class="form-control" id="tipo-new-mov">';
            html += '       <option> Numérico</option>';
            html += '       <option> Real brasileiro (R$)</option>';
            html += '    </select>';
            html += '</div>';

            html += '<div class="form-group">';
            html += '    <label>Agrupar colunas <i class="fa-regular fa-circle-question" data-toggle="tooltip" data-placement="top" data-html="true" title="Adicione os campos que irá visualizar na aba de movimentações"></i></label>';
            html += '    <select class="form-control select2-dynamics-data-movement" multiple="multiple" id="agroupment-column-new-mov">';
            html += '    </select>';
            html += '</div>';
            break;

        default:
            console.log('not found type render');
            break;
    }

    return html;
}

$('#btn-save-item-add-column').on('click', function () {
    const nome = $('#modal-nome-new-column').val();
    const descricao = $('#modal-descricao-new-column').val();
    const tipo = $('#modal-tipo-new-column').val();
    let options = [];

    if (nome == '') {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Por favor, selecione preencha o campo nome',
        });

        return;
    }

    if (typeof tipo !== 'string') {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Por favor, selecione um tipo',
        });
        return;
    }

    if (tipo == 10) {

        if ($('#dinamics-categories').select2('val').length == 0) {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Por favor, descreva as opções',
            });

            return;
        }

        options = order($('#dinamics-categories').select2('val'), 'DESC');
    }

    $('.sppiner-button-add-column').removeClass('d-none');
    $('.sppiner-button-add-column').prop('disabled', true);

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Column.php',
        data: {
            action: 'store',
            nome: nome,
            descricao: descricao,
            tipo: parseInt(tipo),
            options: options
        },
        success: function (data) {

            Swal.fire(
                'Sucesso!',
                'Nova coluna cadastrada com sucesso!',
                'success'
            );

            $('.sppiner-button-add-column').addClass('d-none');
            $('.sppiner-button-add-column').prop('disabled', false);
            setTimeout(() => {
                window.location.reload(false);
            }, 500);
        },
        error: function (xhr) {
            $('.sppiner-button-add-column').addClass('d-none');
            $('.sppiner-button-add-column').prop('disabled', false);
            defaultError();
            return false;
        }
    });
});

$('#modal-tipo-new-column').on('change', function () {

    $('#form-render-html-tipo-column').html('');
    $('#form-render-html-tipo-column').removeClass('d-none');

    if ($(this).val() == 10) {
        $('#form-render-html-tipo-column').html(
            renderHtml('new-categorie')
        );

        select2Multiple('.select2-dynamics-data-categories');

        $('[data-toggle="tooltip"]').tooltip();
        return;
    }

    if ($(this).val() == 9) {
        $('#form-render-html-tipo-column').html(
            renderHtml('new-movement')
        );

        const options = populateSelectWithColumns(getColumns());
        select2Multiple('.select2-dynamics-data-movement', options);

        $('[data-toggle="tooltip"]').tooltip();
        return;
    }

    $('#form-render-html-tipo-column').addClass('d-none');
});

function getColumns() {
    let values = [];

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Column.php',
        data: { action: "getColumns" },
        beforeSend: function () {
            // necessário criar uma loader para o usuário aguardar o carregamento das colunas existentes
        },
        success: function (data) {
            values = data;
        },
        error: function (xhr) {
            console.log('error loaded columns');
        }
    });

    return values;
}

function select2Multiple(selector, data_values = false, callback = false) {
    $(`${selector}`).select2({
        width: '100%',
        tags: true,
        tokenSeparators: [',', ' '],
        "language": {
            "noResults": function () {
                return "Digite a opção e pressione a tecla 'enter'";
            }
        },
        placeholder: "Informe as opções"
    });

    if (data_values) {
        $(`${selector}`).html('').select2({ data: data_values });
    }

    if (callback) {
        callback();
    }
}

function populateSelectWithColumns(array_columns, selector = false, type = 'object') {
    let options = '';
    let options_arr = [];

    for (const [key, e] of Object.entries(array_columns)) {
        not_mov = e[0].type != 1 && e[0].type != 3 ? `data-item-not-mov="${e[0].type}"` : '';
        options += `<option value="${e[0].id}" ${not_mov} data-soft-type-item="${e[0].type}">${e[0].name}</option>`
        options_arr.push({ id: `${e[0].id}`, text: `${e[0].name}` })
    }

    if (selector) {
        select2Multiple(selector, options_arr);
    }

    if (type === 'object') {
        return options_arr;
    }

    return options;
}

function configNewAgroupment() {
    const options = populateSelectWithColumns(getColumns(), false, 'string');
    $('#select-col-add-all-agroupment').html(options);
    select2Multiple('#select-col-add-all-agroupment');
    $('#modal-new-agroupment').modal('show');
}

function configNewMov() {
    const options = populateSelectWithColumns(getColumns(), false, 'string');
    $('#select-col-add-regra-mov').html(options);
    $('option[data-item-not-mov]').remove();

    $('option[data-soft-type-item="1"]').append(' - Tipo: Uni.');
    $('option[data-soft-type-item="3"]').append(' - Tipo: R$');

    $('#select-col-add-all-mov').html(options);
    select2Multiple('#select-col-add-regra-mov');
    select2Multiple('#select-col-add-all-mov');

    $('#btn-save-item-add-mov').prop('disabled', false);
    $('#modal-new-mov').modal('show');
}

$('#select-col-add-regra-mov').on('select2:select', function (e) {
    $(`#select-col-add-all-mov option[value="${e.params.data.id}"]`).prop('disabled', true);
});

$('#select-col-add-regra-mov').on('select2:unselect', function (e) {
    $(`#select-col-add-all-mov option[value="${e.params.data.id}"]`).prop('disabled', false);
});

$('#select-col-add-all-mov').on('select2:select', function (e) {
    $(`#select-col-add-regra-mov option[value="${e.params.data.id}"]`).prop('disabled', true);
});

$('#select-col-add-all-mov').on('select2:unselect', function (e) {
    $(`#select-col-add-regra-mov option[value="${e.params.data.id}"]`).prop('disabled', false);
});

/** 
 * Função responsável por cadastrar nova configuração de movimentação na base de dados
 */
$('#btn-save-item-add-mov').on('click', function () {
    const name = $('#nome-add-mov').val();
    const rules = $('#select-col-add-regra-mov').val();
    const views = $('#select-col-add-all-mov').val();

    if (name.length < 3 || name.length > 50) {
        Swal.fire({
            icon: 'info',
            title: 'Oops...',
            text: 'O nome deve ter entre 4 e 50 caracteres',
            footer: '<a href="mailto:suporte@fattos.com.br">Notou algo de errado? Entre em contato!</a>'
        });

        return;
    }

    if (rules.length < 1 && views.length < 1) {
        Swal.fire({
            icon: 'info',
            title: 'Oops...',
            text: 'Selecione ao menos um item de regra ou a ser exibido!',
            footer: '<a href="mailto:suporte@fattos.com.br">Entrar em contato com o suporte</a>'
        });

        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        data: {
            action: 'configMovement',
            name: name,
            rules: rules,
            views: views
        },
        success: function (data) {
            Swal.fire(
                'Sucesso!',
                'Configurado com sucesso!',
                'success'
            );

            $('#modal-new-mov').modal('hide');
            document.location.reload(true)
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });

});

$('#btn-save-item-add-agroupment').on('click', function() {
    const name = $('#nome-add-agroupment').val();
    const description = $('#modal-descricao-new-agroupment').val();
    const views = $('#select-col-add-all-agroupment').val();

    if (name.length < 3 || name.length > 50) {
        Swal.fire({
            icon: 'info',
            title: 'Oops...',
            text: 'O nome deve ter entre 4 e 50 caracteres',
            footer: '<a href="mailto:suporte@fattos.com.br">Notou algo de errado? Entre em contato!</a>'
        });

        return;
    }

    if (description.length < 5) {
        Swal.fire({
            icon: 'info',
            title: 'Oops...',
            text: 'A descrição deve ter no mínimo 5 caracteres',
            footer: '<a href="mailto:suporte@fattos.com.br">Notou algo de errado? Entre em contato!</a>'
        });

        return;
    }

    if (views.length < 1) {
        Swal.fire({
            icon: 'info',
            title: 'Oops...',
            text: 'Selecione ao menos uma coluna a ser exibida!',
            footer: '<a href="mailto:suporte@fattos.com.br">Entrar em contato com o suporte</a>'
        });

        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Agroupment.php',
        data: {
            action: 'configAgroupment',
            name: name,
            description: description,
            views: views
        },
        success: function (data) {
            Swal.fire(
                'Sucesso!',
                'Configurado com sucesso!',
                'success'
            );

            $('#modal-new-agroupment').modal('hide');
            document.location.reload(true)
        },
        error: function (xhr) {
            Swal.fire(
                'Erro!',
                'Erro ao configurar novo agrupamento!',
                'error'
            );
            
            console.log(xhr);
        }
    });

});

function dataMovement() {
    const table = $(this).attr('data-mov-tbl');
    const id_group = $(this).attr('data-mov-group');

    getColumnsNameMovement(table);
    renderTableMovement(table, id_group);

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        data: {
            action: 'getMovementsJSON',
            table: table,
            group: id_group
        },
        success: function (data) {
            $('#modal-view-mov').modal('show');
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });
}

$('td[data-mov-item]').on('click', dataMovement);

var data_columns_name = '';

function getColumnsNameMovement(table) {
    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        data: {
            action: 'getColumnsNameJSON',
            table: table
        },
        success: function (data) {
            data_columns_name = data;
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });
}

function getDataMovementFrom(table, id_group) {
    let values = '';

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        data: {
            action: 'getValuesMovementJSON',
            table: table,
            idGroup: id_group
        },
        success: function (data) {
            values = data;
        },
        error: function (xhr) {
            console.log('err get data:', xhr);
        }
    });

    return values;
}

function renderTableMovement(table, id_group) {
    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        data: {
            action: 'getColumnsNameJSON',
            table: table
        },
        success: function (data) {
            $('#title-modal-mov').text(data[0].nome);

            let data_order = [];
            let mov_td = '';

            data.reverse().forEach(el => {
                mov_td += `<td data-td-mov-name="${el.nome_coluna}">${el.nome_view}</td>`;
                data_order.push(el.nome_coluna)
            });

            const values_of_table = getDataMovementFrom(table, id_group);

            mov_td += '<td> Opções </td>';
            html_value = '';
            columns_count = [];
            values_of_table.forEach(el => {
                html_value += '<tr>'
                i = 1;

                data_order.forEach(e => {
                    res = el[e];
                    data_count = '';

                    if (isValidDateTime(res)) {
                        res = moment(res).format('DD/MM/YYYY HH:mm');
                    } else if (isValidateImageExtension(res)) {
                        res = `<button class="btn btn-sm btn-outline-primary" data-type-mov-file="image" data-button-show-image-movement="${res}" value="${res}">Visualizar</button>`;
                    } else if (isPdf(res)) {
                        res = `<button class="btn btn-sm btn-outline-danger" data-type-mov-file="pdf" data-button-show-pdf-movement="${res}" value="${res}">Visualizar</button>`;
                    } else if (isFile(res)) {
                        res = `<button class="btn btn-sm btn-outline-danger" data-type-mov-file="other" data-button-show-file-movement="${res}" value="${res}">Visualizar</button>`;
                    } else if (isRealValue(res)) {
                        data_count = `data-count-${i}-sum="${toDollar(res)}"`;
                        columns_count.push(i);
                    } else if (isNumber(res)) {
                        data_count = `data-count-${i}-sum="${res}" data-is-int`;
                        columns_count.push(i);
                    } else if (!res) {
                        res = 'Não informado...';
                    }

                    html_value += `<td data-td-mov-index="${i}" ${data_count}>${res}</td>`
                    i++;
                });

                html_value += `<td><button class="btn btn-sm btn-outline-primary" disabled>Opções (desenv)</button></td>`
                html_value += '</tr>'
            });

            html_tfooter = '';

            let j = 1;
            data_order.forEach(e => {
                html_tfooter += `<th data-result-mov-index="${j}" data-${e}-mov-result></th>`;
                j++;
            });

            html_tfooter += '<th data-option-mov-result></th>';

            $('#render-table-movements').html(
                '<div class="table-responsive">'
                + '    <table id="table_movements" class="table table-bordered table-striped w-100 pt-5">'
                + '        <thead>'
                + '            <tr>'
                + `                 ${mov_td}`
                + '            </tr>'
                + '        </thead>'
                + '        <tbody id="render_tbody_movements">'
                + `             ${html_value}`
                + '        </tbody>'
                + '         <tfoot>'
                + '             <tr>'
                + `                 ${html_tfooter}`
                + '             </tr>'
                + '         </tfoot>'
                + '    </table>'
                + '</div>'
            );

            columns_count.forEach(value => {
                let qtd = 0;
                let isNum = 0;

                $(`td[data-td-mov-index="${value}"]`).each(function () {
                    qtd += parseFloat($(this).attr(`data-count-${value}-sum`));

                    if ($(this).attr("data-is-int") !== undefined) {
                        isNum = 1;
                    }
                });

                const text_total = '<small class="text-muted">Total: </small>';
                let result = isNum === 1 ? text_total + qtd : text_total + formatter.format(qtd);

                $(`th[data-result-mov-index=${value}]`).html(result);
            });

            $('#table_movements').DataTable({
                dom: 'Brtip',
                paging: false, //remove after testing
                buttons: [
                    {
                        text: 'Nova movimentação',
                        action: function (e, dt, node, config) {
                            newMovement(table, id_group)
                        }
                    },
                    'colvis',
                    {
                        extend: 'collection',
                        text: 'Exportar',
                        buttons: ['copyHtml5', 'excelHtml5', 'csvHtml5', 'pdfHtml5'],

                    },
                ],
                "oLanguage": {
                    "sUrl": "../assets/vendor/dataTable/pt-BR.json"
                },
            });

            $('button[data-type-mov-file]').on('click', showModalFileMovement);
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });

}

function newMovement(table, group) {

    $('#modal-new-mov-id-group').val(group);
    $('#modal-new-mov-table').val(table);

    let html = '<div class="row">';

    data_columns_name.forEach(el => {

        html += '<div class="form-group col-xl-4 col-lg-4 col-sm-12 col-xs-12">';
        html += `<label>${el.nome_view}</label>`

        // if (el.tipo_coluna == 10) {
        //     html += `
        //         <select name="${el.nome_coluna}" data-item-mov-id="${el.id}" class="form-control">
        //         <option value="">Nenhum selecionado</option>
        //     `;
        // }

        switch (parseInt(el.tipo_coluna)) {
            case 1:
                // Int
                html += `<input type="number" data-item-mov-id="${el.id}" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control ">`
                break;
            case 2:
                // Text
                html += `<input type="text" data-item-mov-id="${el.id}" maxlength="100" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control ">`
                break;
            case 3:
                // Money - Real
                html += `<input type="text" data-item-mov-id="${el.id}" maxlength="100" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control " data-mask-money placeholder="R$ 0,00">`
                break;
            case 4:
                // Long Text
                html += `<textarea data-item-mov-id="${el.id}" rows="1" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control "></textarea>`
                break;
            case 5:
                // Date
                html += `<input type="date" data-item-mov-id="${el.id}" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control ">`
                break;
            case 6:
                // Date Time
                html += `<input type="datetime-local" data-item-mov-id="${el.id}" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control ">`
                break;
            case 7:
                // Image
                html += `<input type="file" data-item-mov-id="${el.id}" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control " accept="image/*" data-file-mov-input>`;
                break;
            case 8:
                // All documents
                html += `<input type="file" data-item-mov-id="${el.id}" name="${el.nome_coluna}-${el.tipo_coluna}" class="form-control " data-file-mov-input>`;
                break;
            case 9:
                // .docx, .xlsx, .txt, etc...
                html += 'Outros documentos - desenv';
                break;
            case 10:
                // Options
                html += '<br><div class="card" style="border:1px solid #cfcfcf;"><div class="card-body p-2" style="padding-bottom: 4px !important;"><small>Campo de opçoes: Estou realizando testes na desenv...</div></div></strong>';
                // html += `<option value="${ e[i][key + '_id'] }">${ e[i][key + '_name'] }</option>`;
                break;
            default:
                console.error('contate o administrador: ' + el.tipo_coluna);
                break;
        }

        html += '</div>';
    });

    html += '</div>';

    $('#render-inputs-new-movement').html(html);

    activeMaskMoney();

    $('#btn-save-item-add-item-mov').prop('disabled', false);
    $('#btn-save-item-add-item-mov').removeClass('c-n');
    $('.sppiner-button-add-item-mov').addClass('d-none');

    $('#modal-add-mov').modal('show');
}

$('#btn-save-item-add-item-mov').on('click', function () {
    const max_file_size = 20 * 1024 * 1024; // 20MB em Bytes
    let count_limit = 0;
    let data = new FormData();
    let form_data = $('#render-inputs-new-movement').serializeArray();

    $.each(form_data, function (key, input) {
        data.append(input.name, input.value);
    });

    let files_mov_count = $('input[data-file-mov-input]').length;
    for (var i = 0; i < files_mov_count; i++) {
        if (typeof $('input[data-file-mov-input]')[i].files[0] === 'undefined') {
            continue;
        }

        data.append(
            $('input[data-file-mov-input]')[i].name,
            $('input[data-file-mov-input]')[i].files[0]
        );

        count_limit += $('input[data-file-mov-input]')[i].files[0].size ?? 0;
    }

    if (count_limit > max_file_size) {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: `A soma de imagens e arquivos não podem ultrapassar ${(max_file_size / 1024 / 1024)}MB`,
            footer: '<a href="mailto:suporte@fattos.com.br">Notou algo de errado? Entre em contato!</a>'
        });

        return;
    }

    data.append('table_insert', $('#modal-new-mov-table').val());
    data.append('id_grupo_FK', $('#modal-new-mov-id-group').val());
    data.append('action', 'createMovement');

    $('#btn-save-item-add-item-mov').prop('disabled', true);
    $('#btn-save-item-add-item-mov').addClass('c-n');
    $('.sppiner-button-add-item-mov').removeClass('d-none');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Movement.php',
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {

            Swal.fire(
                'Sucesso!',
                'Novo item cadastrado com sucesso!',
                'success'
            );
            update = 1;
            $('#modal-add-mov').modal('hide');
            renderTableMovement($('#modal-new-mov-table').val(), $('#modal-new-mov-id-group').val());
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });

});

var update = 0;
$('#modal-view-mov, #modal-new-line').on('hidden.bs.modal', function (e) {
    if (update === 1) {
        loading();
        window.location.reload(false);
    }
});

function editInfo(group) {
    console.log(group);
}

function deleteInfo(group) {

    // Refatorar (capturar id do grupo referente a linha do botão clicado);
    const tbl_name = $(`td[data-mov-group='${group}']`).first().attr('data-mov-tbl');

    Swal.fire({
        title: 'Deseja deletar esta linha?',
        text: "Você não será capaz de reverter essa ação!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#909394',
        confirmButtonText: 'Sim, deletar!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.value) {
            loading();
            const response = destroyInfo(parseInt(group), tbl_name);

            if (!response) {
                defaultError();
                return;
            }

            Swal.fire(
                'Sucesso!',
                'Linha deletada com sucesso!',
                'success'
            );

            setTimeout(() => {
                window.location.reload(false);
            }, 600);
        }
    });
}

function destroyInfo(group, tbl) {
    let status = false;

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Info.php',
        data: {
            action: "destroy",
            id: group,
            tbl: tbl
        },
        success: function (data) {
            status = true;
        },
        error: function (xhr) {
            defaultError();
        },
        complete: function () {
            loading(false);
        }
    });

    return status;
}

function getInfoId(id_group) {
    let values = [];

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Info.php',
        data: {
            action: "getGroupId",
            id: id_group
        },
        success: function (data) {
            values = data;
        },
        error: function (xhr) {
            defaultError();
        },
        complete: function () {
            loading(false);
        }
    });

    return values;
}

function renderFormEditId(id_group) {
    const columns = getColumns();
    const items = getInfoId(id_group);

    let html = '<div class="row">';
    html += `<input type="hidden" name="id_group" value="${id_group}">`;

    for (const [key, e] of Object.entries(columns)) {

        html += '<div class="form-group col-xl-4 col-lg-4 col-sm-12 col-xs-12">';
        html += `<label>${e[0].name}</label>`
        data_name = `data-edit-name="${e[0].name}"`;
        data_column_id = `data-edit-column="${key}"`;
        if (e[0].type == 10) {
            html += `
                <select ${data_name} ${data_column_id} name="${e[0].id}-10" class="form-control items-doc-input-edit">
                <option value="">Nenhum selecionado</option>
            `;
        }

        e.forEach((el, i) => {

            disabled = el.isMoviment == 1 ? 'disabled placeholder="Campo bloqueado (movimentação)"' : '';

            switch (el.type) {
                case 1:
                    // Int
                    html += `<input ${disabled} ${data_column_id} type="number" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-edit">`
                    break;
                case 2:
                    // Text
                    html += `<input ${disabled} ${data_column_id} type="text" ${data_name} maxlength="100" name="${el.id}-${el.type}" class="form-control items-doc-input-edit">`
                    break;
                case 3:
                    // Money - Real
                    html += `<input ${disabled} ${data_column_id} type="text" ${data_name} maxlength="100" name="${el.id}-${el.type}" class="form-control items-doc-input-edit" data-mask-money placeholder="R$ 0,00">`
                    break;
                case 4:
                    // Long Text
                    html += `<textarea ${disabled} ${data_column_id} ${data_name} rows="1" name="${el.id}-${el.type}" class="form-control items-doc-input-edit"></textarea>`
                    break;
                case 5:
                    // Date
                    html += `<input ${disabled} ${data_column_id} type="date" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-edit">`
                    break;
                case 6:
                    // Date Time
                    html += `<input ${disabled} ${data_column_id} type="datetime-local" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-edit">`
                    break;
                case 7:
                    // Image
                    html += `<input ${disabled} ${data_column_id} type="file" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-edit" accept="image/*" data-file-edit-input>`;
                    break;
                case 8:
                    // All document
                    html += `<input ${disabled} ${data_column_id} type="file" ${data_name} name="${el.id}-${el.type}" class="form-control items-doc-input-edit" data-file-edit-input>`;
                    break;
                case 9:
                    // Implements
                    break;
                case 10:
                    // Options
                    html += `<option ${disabled} ${data_column_id} value="${e[i][key + '_id']}">${e[i][key + '_id']} - ${e[i][key + '_name']}</option>`;
                    break;
                default:
                    console.error('contate o administrador');
                    break;
            }

        });

        if (e[0].type == 10) {
            html += `</select>`;
        }

        html += '</div>';
    }

    html += '</div>';

    $('#modal-body-edit-line').html(html);

    for (const [key, e] of Object.entries(items)) {

        e.forEach((el, i) => {

            switch (el.id_type) {
                case 1:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_int);
                    break;
                case 2:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_text);
                    break;
                case 3:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_money);
                    break;
                case 4:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_text);
                    break;
                case 5:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_date);
                    break;
                case 6:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_date_time);
                    break;
                case 7:
                    // estudar implementar btn-view + input
                    break;
                case 8:
                    // desenv
                    break;
                case 9:
                    // desenv
                    break;
                case 10:
                    $(`.items-doc-input-edit[data-edit-column="${el.id_coluna}"]`).val(el.info_int);
                    break;
                default:
                    break;
            }
        });

    }

    $('#modal-edit-line').modal('show');

    activeMaskMoney();
}

$('#btn-save-item-edit').on('click', function () {
    let data = new FormData();
    let form_data = $('#modal-body-edit-line').serializeArray();

    $.each(form_data, function (key, input) {
        data.append(input.name, input.value);
    });

    let files_count = $('input[data-file-edit-input]').length;
    for (var i = 0; i < files_count; i++) {
        data.append(
            $('input[data-file-edit-input]')[i].name,
            $('input[data-file-edit-input]')[i].files[0]
        );
    }

    data.append('action', 'update');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: '../assets/backend/Info.php',
        contentType: false,
        processData: false,
        data: data,
        beforeSend: function () {
            loading();
        },
        success: function (data) {
            loading(false);

            Swal.fire(
                'Sucesso!',
                'Item atualizado com sucesso!',
                'success'
            );

            setTimeout(() => {
                window.location.reload(false);
            }, 300);

        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
            return false;
        }
    });
});

$(document).ready(function () {
    const buttonsTop = $(".dt-buttons").offset().top;

    $(window).scroll(function () {
        const sidebarWidth = $(".sidebar").outerWidth();
        const scrollTop = $(window).scrollTop();

        if (scrollTop >= buttonsTop) {
            if (sidebarWidth > 200) {
                $(".dt-buttons, .dataTables_filter").addClass("fixed-top ml-sidebar-show-table");
                return;
            }

            $(".dt-buttons, .dataTables_filter").addClass("fixed-top");
            return;
        }

        $(".dt-buttons, .dataTables_filter").removeClass("fixed-top");
        $(".dt-buttons, .dataTables_filter").removeClass("ml-sidebar-show-table");
    });
});

setTimeout(() => {
    $('input[aria-controls="table_id"]').on('keyup', function () {

        calculateColumns().then(resultado => {
            console.info(`Promise search: Calculo finalizado`);
        }).catch(erro => {
            console.error(`Erro ao calcular: ${erro}`);
        });
    });
}, 50);

setTimeout(() => {
    $('.buttons-colvis').on('click', function () {
        $(".dt-button-collection").draggable();
    });
}, 300);