const path_core = '../app/Core/';

function updateTax() {
    const id = $('#tax-id').val();
    const menorPrecoValorAnterior = $('#input-menor-old-value').val();
    const menorPreco = $('#input-menor').val();

    const condicaoIdeal = $('#input-ideal').val();
    const condicaoIdealValorAnterior = $('#condicao_ideal-old-value').val();

    const precoComMargem = $('#input-margem').val();
    const precoComMargemValorAnterior = $('#preco_com_margem-old-value').val();

    const inputs = [menorPreco, condicaoIdeal, precoComMargem];

    if(!isValidTax(inputs)) return;

    const menorPrecoComissao = $('#input-menor-comisao').val();
    const menorPrecoComissaoValorAnterior = $('#input-menor-comissao-old-value').val();

    const condicaoIdealComissao = $('#input-ideal-comisao').val();
    const condicaoIdealComissaoValorAnterior = $('#input-ideal-comissao-old-value').val();

    const precoComMargemComissao = $('#input-com-margem-comisao').val();
    const precoComMargemComissaoValorAnterior = $('#input-com-margem-old-value').val();

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Tax.php`,
        data: {
            id : id,

            menorPrecoValorAnterior: menorPrecoValorAnterior,
            menorPreco : menorPreco,
            condicaoIdealValorAnterior: condicaoIdealValorAnterior,
            condicaoIdeal : condicaoIdeal,
            precoComMargemValorAnterior : precoComMargemValorAnterior,
            precoComMargem : precoComMargem,

            menorPrecoComissao : menorPrecoComissao,
            menorPrecoComissaoValorAnterior : menorPrecoComissaoValorAnterior,
            condicaoIdealComissao : condicaoIdealComissao,
            condicaoIdealComissaoValorAnterior : condicaoIdealComissaoValorAnterior,
            precoComMargemComissao : precoComMargemComissao,
            precoComMargemComissaoValorAnterior : precoComMargemComissaoValorAnterior,
            
            action : 'update'
        },
        success: function (data) {
            console.log(data);

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Taxa atualizada com sucesso!',
                timer: 3000
            });

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';

            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function isValidTax(inputs) {
    let taxPositive = true;
    $.each(inputs, function(index, input) {
        if (!input || input.length === 0 || input === "" || Number(input) < 0) {
            fat_alert({
                title: 'Campos obrigatórios',
                message: 'Por favor, preencha com apenas números inteiros positivos.',
                type: 'danger',
                timer: 2000
            });

            taxPositive = false;
            return false;
        }
    });

    return taxPositive;
}

function clearInputsTax() {
    $('#input-menor').val('0');
    $('#input-ideal').val('0');
    $('#input-margem').val('0');
}

$('#btn-save-tax').on('click', updateTax);
$('#btn-clear-tax').on('click', clearInputsTax);