const path_core = '../app/Core/';
function createUser() {
    const nivel = parseInt($('#nivel-modal-create-user').val());
    const nome = $('#nome-modal-create-user').val().trim();
    const email = $('#email-modal-create-user').val().trim();
    const senha = $('#senha-modal-create-user').val();
    const senha_novamente = $('#senhanovamente-modal-create-user').val();
    const image = $('#image-modal-create-user')[0].files[0];
    let data = new FormData();

    const inputs = [nivel, nome, email, senha, senha_novamente]

    if (!isRequiredInputs(inputs)) return;
    if (!isValidNivel(nivel)) return;
    if (!isValidName(nome)) return;
    if (!isValidEmail(email)) return;
    if (!isValidPassword(senha, senha_novamente)) return;
    if (!valideteSizeByTagId($('#image-modal-create-user'), (5 * 1024 * 1024))) return;

    data.append('nome', nome);
    data.append('email', email);
    data.append('senha', senha);
    data.append('nivel', nivel);
    data.append('imagem', image);
    data.append('action', 'store');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Usuário cadastrado com sucesso!',
                timer: 3000
            });

            $('#modal-new-user').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function openModalUpdateUser(id) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        data: {
            action: 'getDataUser',
            idUser: id
        },
        success: function (data) {
            $('#nome-modal-edit-user').val(data.nome);
            $('#email-modal-edit-user').val(data.email);
            $('#nivel-modal-edit-user').val(data.nivel);
            $('#modal-edit-user-id').val(id);
            $('#modal-edit-user').modal('show');
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
        }
    });
}

function updateUser() {
    const id = $('#modal-edit-user-id').val();
    const nivel = parseInt($('#nivel-modal-edit-user').val());
    const nome = $('#nome-modal-edit-user').val();
    const email = $('#email-modal-edit-user').val();

    const inputs = [nivel, nome, email]

    if (!isRequiredInputs(inputs)) return;
    if (!isValidName(nome)) return;
    if (!isValidEmail(email)) return;

    let data = new FormData();

    data.append('id', id);
    data.append('nivel', nivel);
    data.append('nome', nome);
    data.append('email', email);
    data.append('action', 'update');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Usuário atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-edit-user').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    })
}

function modalShowStatusUser(id, status, name) {
    if (status === 1) {
        $('#modal-user-toggle-status-title').html('Desativar usuário');
        $('#modal-user-toggle-status-message').html('Você quer realmente desativar o usuário <b>' + name + '</b>?');
    } else if (status === 0) {
        $('#modal-user-toggle-status-title').html('Ativar usuário');
        $('#modal-user-toggle-status-message').html('Você quer realmente ativar o usuário <b>' + name + '</b>?');
    }

    $('#modal-user-status-id').val(id);
    $('#modal-user-status-current-status').val(status);
    $('#modal-user-status-name').val(name);
    $('#modal-user-status').modal('show')
}

function toggleStatusUser() {
    const id = $('#modal-user-status-id').val();
    const status = $('#modal-user-status-current-status').val();
    const name = $('#modal-user-status-name').val();

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        data: {
            action: 'changeUserStatus',
            id: id,
            status: status
        },
        success: function (data) {
            console.log(data)
            let liText = (data.status === 1) ? "Desativar" : "Reativar";
            let liOption = `<button class='dropdown-item' type='button' onclick='modalShowStatusUser(${id}, ${data.status}, "${name}")'>${liText}</button>`;

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Usuário atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-user-status').modal('hide');


            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

$('input[data-tester-user-id').on('change', function() {
    const userId = $(this).data('tester-user-id');
    const isTester = $(this).is(':checked');

    $.ajax({
        url: `${path_core}User.php`,
        type: 'POST',
        data: {
            action: 'changeTester',
            userId: userId,
            isTester: isTester ? 1 : 0
        },
        success: function(response) {
            fat_alert({
                type: isTester ? 'primary' : 'warning',
                title: 'Atenção',
                message: isTester ? 'Usuário agora é um testador' : 'Usuário não é mais um testador',
                timer: 2500
            });   
        },
        error: function(xhr) {
            console.log(xhr);
        }
    });
});

$('#btn-add-new-user').on('click', createUser);
$('#btn-add-edit-user').on('click', updateUser);
$('#btn-modal-user-status').on('click', toggleStatusUser);