/**
 * 
 * @param prop {
 *      type: success, warning, danger...
 *      title: título do alerta
 *      message: mensagem do alerta
 *      ?timer: tempo para sumir o alerta
 *      ?callback: aceita uma função anonima
 * }
 * 
 */

var alertTimeout = null;

function fat_alert(prop) {
    if (alertTimeout) {
        clearTimeout(alertTimeout);
        alertTimeout = null;
    }

    if ( $('#fat-alert').length > 0) $("#fat-alert").remove();

    const icon  = prop.type == 'danger' ? 'bx-error' : 'bx-bell';

    let html = `
        <div id="fat-alert" class="bs-toast toast toast-placement-ex m-2 fade bg-${prop.type} bottom-0 end-0 show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <i class="bx ${icon} me-2"></i>
                <div class="me-auto fw-semibold">${prop.title}</div>
                <small id="toast-error-timer-regressive"></small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">${prop.message}</div>
        </div>`;

    $('body').append(html);

    if (prop.timer > 0 ) {
        alertTimeout = setTimeout(function() {
            $("#fat-alert").remove();
        }, prop.timer);
    }

    if (prop.callback) {
        prop.callback();
    }
}
