<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php';

$filter = isset($_GET['filter']) ? $_GET['filter'] : '';

?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Orçamentos</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link href="assets/css/quill.snow.css" rel="stylesheet">
    <link href="assets/css/quill.bubble.css" rel="stylesheet">

    <link rel="stylesheet" href="assets/vendor/filepond/filepond-plugin-image-preview.min.css">
    <link rel="stylesheet" href="assets/vendor/filepond/filepond.min.css">

    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <!-- Page CSS -->

    <style>
        .centered-select {
            display: block;
            margin: auto;
            width: 133px;
        }

        .tab-form,
        .tab-form-contact {
            display: none;
        }

        .step-form,
        .step-form-contact {
            height: 15px;
            width: 15px;
            margin: 0 2px;
            background-color: #bbbbbb;
            border: none;
            border-radius: 50%;
            display: inline-block;
            opacity: 0.5;
        }

        .step-form.active,
        .step-form-contact.active {
            opacity: 1;
        }

        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container,
        .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }

        .filepond--credits {
            color: #fff !important;
        }

        .filepond--root .filepond--drop-label {
            background-color: transparent;
            min-height: 6.6em;
            border-block-end: none !important;
            border-radius: .375rem;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            border-bottom: 1px solid #d9dee3;
            /* height: 40px !important; */
        }

        

        #context-menu {
            display: none;
            position: absolute;
            z-index: 1000;
        }
    </style>

    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <?php

                    $budgets = new App\Core\Budgets;

                    $htmlOptions = '';
                    foreach ((new App\Core\Status)->showList() as $status) {
                        $htmlOptions .= "<option value='$status[id]'>$status[nome]</option>";
                    }
                    $htmlOptions .= "<option value='99'>Perdido - Falta de retorno</option>";

                    ?>

                    <div class="container-fluid flex-grow-1 container-p-y">
                        <!-- <div class="alert alert-warning" role="alert">
                            <i class="bx bx-bell"></i>
                            Tela em desenvolvimento! Cadastre e visualize seus orçamentos <u><a style="color:darkorange" href="budgets.php">aqui</a></u>
                        </div> -->
                        <div class="card mb-3">
                            <div class="card-header">
                                <div class="d-flex justify-content-between gap-2">
                                    <div>
                                        <?php if ($_SESSION['user']['nivel'] != 3): ?>

                                            <button class="btn btn-sm btn-primary text-truncate h-px-30" type="button" id="btn-novo-orcamento" onclick="novoOrcamento()">
                                                <i class="bx bx-wallet me-sm-1"></i>
                                                Novo Orçamento
                                            </button>
                                        <?php endif; ?>
                                    </div>

                                    <div class="d-flex gap-2">
                                        <div class="">
                                            <select
                                                id="select-filter-status"
                                                class="form-select h-px-30"
                                                style="height: 32px;"
                                                title="Filtrar por status"
                                                data-bs-toggle="tooltip">
                                                <option value="">Todos os status</option>
                                                <?= $htmlOptions ?>
                                            </select>
                                        </div>
                                        <div class=" ">
                                            <select
                                                id="select-filter-retorno"
                                                class="form-select h-px-30"
                                                style="height: 32px; width: 150px"
                                                title="Filtrar por data de retorno"
                                                data-bs-toggle="tooltip">
                                                <option value="">Todos as datas</option>
                                                <option value="this">Hoje</option>
                                                <option value="next">Amanhã</option>
                                                <option value="future">Futuro</option>
                                                <option value="last">Atrasado</option>
                                            </select>
                                        </div>
                                        <?php if ($_SESSION['user']['nivel'] > 7): ?>
                                            <div class="">
                                                <select id="tipo-filter-vendedor" class="form-select h-px-30">
                                                    <option value="">Carregando...</option>
                                                </select>
                                            </div>
                                        <?php endif; ?>
                                        <div class="d-flex h-px-30">
                                            <input
                                                autofocus=""
                                                class="form-control me-1"
                                                type="text"
                                                value="<?= $filter ?>"
                                                id="text-filter-orcamento"
                                                placeholder="Buscar..."
                                                data-bs-toggle="tooltip"
                                                title="Filtrar por cliente ou vendedor">
                                            <button class="btn btn-sm btn-primary" id="btn-filter-orcamento">Buscar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive scrollbar">
                                    <table class="table table-sm table-striped table-hover table-bordered fs--1 mb-0 overflow-hidden">
                                        <thead class="bg-200 text-900">
                                            <tr>
                                                <th class="sort white-space-nowrap">#</th>
                                                <th class="sort pe-1 white-space-nowrap">Ordem</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Data orçado </th>
                                                <th class="sort pe-1 white-space-nowrap text-center" style="min-width: 12.5rem;">Cliente</th>
                                                <th class="sort pe-1 white-space-nowrap text-center w-px-200">Status</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Data retorno</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Valor total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="list" id="table-orders-body">

                                            <?php

                                            $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                                            $limit_per_page = 10;

                                            $budgetList = $budgets->showList($current_page, $limit_per_page, $filter);

                                            // echo '<pre style="background-color: #000; color: #fff">';
                                            // print_r($budgetList['data']);
                                            // echo '</pre>';

                                            foreach ($budgetList['data'] as $key => $value):
                                                $td_attr_dialogo = strlen($value['dialogo']) > 29 ? "
                                                        class='c-h py-2 align-middle white-space-nowrap'
                                                        data-bs-toggle='tooltip' 
                                                        data-bs-placement='top'
                                                        data-bs-html='true'
                                                        title='$value[dialogo]'" : '';

                                                $dialogo = strlen($value['dialogo']) > 29 ? substr($value['dialogo'], 0, 30) . '... <i class="bx bx-xs bx-copy-alt c-p" onclick="copyToClipboard(\'' . $value['dialogo'] . '\')" data-bs-placement="bottom" data-bs-toggle="tooltip" title="Clique para copiar o diálogo com o cliente"></i>' : $value['dialogo'];

                                                $statusSistema = '<small>' . $value['statusSistema'] . '</small>';

                                                if ($value['statusSistema'] == 1) {
                                                    $statusSistema = '<small>' . $value['dataRetornoBr'] . ' - Pedido fechado </small>';
                                                }

                                                if ($value['statusSistema'] == -1) {
                                                    $statusSistema = '<small>' . $value['dataRetornoBr'] . ' - Perdido por inatividade</small>';
                                                }

                                                if ($value['statusSistema'] == 0) {
                                                    $statusSistema = '<small>' . $value['dataRetornoBr'] . ' - Perdido</small>';
                                                }
                                            ?>
                                                <tr>
                                                    <td class="p-0 text-center">
                                                        <input type="checkbox" class="form-check-input checkbox-select-orcamento" value="<?= $value['id'] ?>">
                                                    </td>
                                                    <td class="align-middle white-space-nowrap text-truncate">
                                                        <a href="#" onclick="viewBudget(<?= $value['id'] ?>)">
                                                            <strong><span class="badge bg-label-primary">#<?= $value['id'] ?></span></strong>
                                                        </a>
                                                        por
                                                        <img class="avatar avatar-xxs pull-up rounded-3 border" src="assets/file/user/<?= $value['img_usuario'] ?>"
                                                            onclick="showImage(this.src)"
                                                            onerror='this.src="assets/file/system/undraw_profile.svg"'
                                                            alt="Avatar" class="rounded-circle" />
                                                        <strong><label class="form-label m-0 fw-bold" data-bs-toggle="tooltip" title="<?= $value['email'] ?>"><?= $value['nome'] ?></label></strong>
                                                    </td>
                                                    <td class="align-middle text-center text-truncate"><small><?= $value['data_orcado'] ?></small></td>
                                                    <td><?= $value['cliente'] ?></td>
                                                    <td class="align-middle text-center white-space-nowrap d-flex justify-content-center">
                                                        <div>
                                                            <?php

                                                            if ($value['statusSistema'] == 0) {
                                                                echo "<span class='badge bg-label-warning' style='width:133px; height: 22px; background-color: transparent !important;'><b>" . $value['nomeStatus'] . "</b></span>";
                                                            } else if ($value['statusSistema'] == -1) {
                                                                echo "<span class='badge bg-label-danger' style='width:133px; height: 22px; background-color: transparent !important;'><b>Perdido</b></span>";
                                                            } else if ($value['statusSistema'] == 1) {

                                                                echo "<span class='badge bg-label-success' style='width:133px; height: 25px; background-color: transparent !important;'>
                                                                        <b>Ganho</b>
                                                                        <i class='bx bx-check-double text-success c-h' data-bs-toggle='tooltip' title='Pedido enviado para produção'></i></a>
                                                                    </span>
                                                                ";
                                                            } else {
                                                                $currentOptions = str_replace("value='$value[status_user]'", "value='$value[status_user]' selected", $htmlOptions);

                                                                echo '<select class="form-select form-select-sm border-0 select-change-status-table centered-select" data-orcamento-id="' . $value['id'] . '">';
                                                                echo $currentOptions;
                                                                echo '</select>';
                                                            }

                                                            ?>
                                                        </div>
                                                    </td>
                                                    <td class="align-middle text-center">
                                                        <i class="bx bx-edit-alt c-p me-1" onclick="editaDataRetorno(<?= $value['id'] ?>)"></i>
                                                        <?= $statusSistema ?>
                                                    </td>
                                                    <td class="align-middle text-end fs-0 fw-medium text-truncate" data-id-orcamento-set-valor="<?= $value['id'] ?>">
                                                        <small><b>R$</b></small> <?= number_format($value['valor_total'], 2, ',', '.') ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php
                            echo '<div class="dynamic-pagination col text-center mb-3">' . $budgetList['pages'] . '</div>';
                            ?>
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Modals -->
    <?php
    include __DIR__ . '/partials/modal/modal_create_budgets.html';
    include __DIR__ . '/partials/modal/modal_view_budget.html';
    include __DIR__ . '/partials/modal/modal_loser_budget.html';
    include __DIR__ . '/partials/modal/modal_view_pdf_budget.html';
    include __DIR__ . '/partials/modal/modal_show_image.html';
    ?>

    <div class="modal fade" id="modal-show-layout" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered rounded" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-0">
                    <div class="form-grop">
                        <label class="form-label">Layout(s) <small class="text-danger fs-tiny">Recurso em teste</small></label>
                        <input multiple="multiple" id="anexos-filepond" data-allow-reorder="true" type="file" class="form-control filepond filepond-create">
                    </div>
                </div>
                <div class="modal-footer" style="z-index: 999999 !important;">
                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-sm btn-primary" id="btn-save-layout">Salvar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-edit-data-retorno" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered rounded" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title-edit-data-retorno">Editar data de retorno</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-grop">
                        <input class="form-control" type="date" id="data-edit-data-retorno" required>
                    </div>
                </div>
                <div class="modal-footer" style="z-index: 999999 !important;">
                    <input type="hidden" id="id-edit-data-retorno">
                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-sm btn-primary" id="btn-save-data-retorno">Salvar</button>
                </div>
            </div>
        </div>
    </div>

    <div id="context-menu" class="dropdown-menu">
        <!-- <a class="dropdown-item" href="#" id="view-budget">Visualizar Orçamento</a> -->
        <a class="dropdown-item" href="#" id="edit-layout">Visualizar/Editar Layout</a>
    </div>

    <!-- / Modals -->
    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/jquery-mask/jquery-mask-update.min.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src='assets/vendor/fullcalendar/script.min.js'></script>
    <script src="assets/vendor/maskMoney/jquery.maskMoney.min.js"></script>
    <script src="assets/js/quill.min.js"></script>
    <script src="assets/vendor/select2/select2.min.js"></script>

    <script src="https://unpkg.com/filepond-plugin-file-encode/dist/filepond-plugin-file-encode.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-file-validate-size/dist/filepond-plugin-file-validate-size.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-file-validate-type/dist/filepond-plugin-file-validate-type.js"></script>
    <script src="https://unpkg.com/filepond-plugin-image-exif-orientation/dist/filepond-plugin-image-exif-orientation.min.js"></script>
    <script src="https://unpkg.com/filepond-plugin-image-preview/dist/filepond-plugin-image-preview.min.js"></script>
    <script src="https://unpkg.com/filepond/dist/filepond.min.js"></script>
    <!-- endbuild -->


    <?php if ($_SESSION['user']['nivel'] == 3): ?>
        <script>
            $('#btn-open-modal-edit-budget').remove();
        </script>
    <?php endif; ?>

    <?php if ($_SESSION['user']['nivel'] < 8): ?>
        <script>
            $('.checkbox-valor-manual').parent().remove();
        </script>
    <?php endif; ?>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>

    <script src="assets/js/budget.js"></script>
    <script src="assets/js/budget-list.js"></script>
    <script src="assets/js/budget-dialog.js"></script>
    <script src="assets/js/budget-edit.js"></script>


    <script>
        FilePond.registerPlugin(FilePondPluginFileValidateType);
        FilePond.registerPlugin(FilePondPluginImagePreview);
        FilePond.registerPlugin(FilePondPluginFileEncode);
        FilePond.registerPlugin(FilePondPluginFileValidateSize);
        FilePond.registerPlugin(FilePondPluginImageExifOrientation);

        const pond = FilePond.create(document.querySelector('#anexos-filepond'), {
            // name: element.name,
            labelIdle: 'Arraste e solte seus arquivos ou <span class="filepond--label-action">selecione</span>',
        });

        function getFilePondFiles() {
            return pond.getFiles().map(fileItem => fileItem.file);
        }

        $('#btn-save-layout').on('click', function() {
            const files = getFilePondFiles();
            const budgetId = currentBudgetId;

            const formData = new FormData();
            formData.append('action', 'saveAttachments');
            formData.append('idOrcamento', budgetId);

            files.forEach(file => {
                formData.append('anexos[]', file);
            });

            $.ajax({
                type: 'POST',
                url: `${path_core}Orcamentos.php`,
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    console.log('Arquivos salvos:', response);
                    fat_alert({
                        type: 'success',
                        title: 'Sucesso!',
                        message: 'Arquivos salvos com sucesso!',
                        timer: 2500
                    });
                    // $('#modal-show-layout').modal('hide');
                },
                error: function(xhr) {
                    console.error('Erro ao salvar arquivos:', xhr);
                    fat_alert({
                        type: 'danger',
                        title: 'Oops...',
                        message: 'Erro ao salvar arquivos!',
                        timer: 4000
                    });
                }
            });
        });

        var currentBudgetId = null;

        document.addEventListener('DOMContentLoaded', function() {
            const contextMenu = document.getElementById('context-menu');

            document.querySelectorAll('tr').forEach(function(row) {
                row.addEventListener('contextmenu', function(event) {
                    event.preventDefault();

                    console.log('uahsduashudh');
                    

                    document.querySelectorAll('tr').forEach(function(row) {
                        $(row).removeClass('bg-label-secondary');
                    });

                    $(row).addClass('bg-label-secondary');

                    currentBudgetId = row.querySelector('.checkbox-select-orcamento').value;
                    contextMenu.style.top = `${event.clientY}px`;
                    contextMenu.style.left = `${event.clientX}px`;
                    contextMenu.style.display = 'block';
                });
            });

            document.addEventListener('click', function(event) {
                if (!event.target.closest('#context-menu')) {
                    contextMenu.style.display = 'none';
                    document.querySelectorAll('tr').forEach(function(row) {
                        $(row).removeClass('bg-label-secondary');
                    });
                }
            });

            // document.getElementById('view-budget').addEventListener('click', function() {
            //     if (currentBudgetId) {
            //         viewBudget(currentBudgetId);
            //     }
            // });

            document.getElementById('edit-layout').addEventListener('click', function() {
                if (currentBudgetId) {
                    console.log(currentBudgetId);

                    loadAttachments(currentBudgetId);
                    $('#modal-show-layout').modal('show');
                }
            });

            function loadAttachments(budgetId) {
                pond.removeFiles();

                $.ajax({
                    type: 'POST',
                    dataType: 'JSON',
                    url: `${path_core}Orcamentos.php`,
                    data: {
                        action: 'getAttachments',
                        idOrcamento: budgetId
                    },
                    success: function(response) {
                        console.log('Arquivos retornados:', response);
                        
                        // Adiciona os arquivos retornados pela API
                        response.forEach(file => {
                            pond.addFile('assets/file/orcamento-anexos/' + file.nome);
                        });
                    },
                    error: function(xhr) {
                        console.error('Erro ao carregar anexos:', xhr);
                    }
                });
            }
        });

    

        const urlParams = new URLSearchParams(window.location.search);
        const ref = urlParams.get('ref'); // id do contato

        function novoOrcamento() {
            modalCreateSanitizeInputs();

            $('#is-contact-to-budget').val(0);
            $('#id-ref-contact').val(0);

            if (ref) {
                $('#id-ref-contact').val(ref);
            }

            if (html_clone_product == null) {
                html_clone_product = $("#div-item").html();
            }

            $('.select-product').select2({
                dropdownParent: $("#modal-new-budget"),
                width: '100%'

            });

            $('#prevBtn').removeClass('d-none');
            $('#modal-new-budget').modal('show');

            fat_alert({
                type: 'dark',
                title: 'Atenção 🧐',
                message: "Todos os campos com '*' são obrigatórios",
                timer: 4000
            });

            $('#type-modal, #id-budget-update').val(0);

            setTimeout(() => {
                if (!ref) {
                    $('#select-customers').select2('open');
                }
            }, 500);
        }

        function copyToClipboard(copyText) {
            navigator.clipboard.writeText(copyText);
            fat_alert({
                type: 'dark',
                title: 'Texto copiado',
                message: copyText,
                timer: 2500
            });
        }

        function showImage(image) {
            $('#modal-show-img').modal('show');
            $('#show-image').attr('src', image);
        }

        $('.select-change-status-table').on('change', function() {
            const id = $(this).data('orcamento-id');
            const status = $(this).val();

            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}Orcamentos.php`,
                data: {
                    action: 'updateStatus',
                    id: id,
                    status: status
                },
                success: function(data) {
                    console.log(data);
                    fat_alert({
                        type: 'primary',
                        title: 'Sucesso!',
                        message: 'Status atualizado com sucesso!',
                        timer: 2500
                    });
                },
                error: function(xhr) {
                    fat_alert({
                        type: 'danger',
                        title: 'Oops...',
                        message: 'Erro ao atualizar status!',
                        timer: 4000
                    });
                }
            });
        });

        $('#btn-filter-orcamento').on('click', filtrarOrcamento);

        $('#text-filter-orcamento').keypress(function(event) {
            if (event.which === 13) {

                filtrarOrcamento();
            }
        });

        function filtrarOrcamento() {
            const text = $('#text-filter-orcamento').val();
            const status = $('#select-filter-status').val();
            const retorno = $('#select-filter-retorno').val();
            const vendedor = $('#tipo-filter-vendedor').val(); // Obtém o valor do elemento com id 'tipo-filter-vendedor'

            let currentURL = window.location.href;

            // Remove os parâmetros "page", "startDate", "endDate" e "filter" se existirem
            currentURL = currentURL.replace(/(\?|&)page=[^&]*/, '');
            currentURL = currentURL.replace(/(\?|&)filter=[^&]*/, '');
            currentURL = currentURL.replace(/(\?|&)status=[^&]*/, '');
            currentURL = currentURL.replace(/(\?|&)retorno=[^&]*/, '');
            currentURL = currentURL.replace(/(\?|&)vendedor=[^&]*/, '');
            currentURL = currentURL.replace(/(\?|&)orcamentoId=[^&]*/, '');
            currentURL = currentURL.replace(/[?&]$/, '');

            currentURL += `?page=1`;

            if (text) {
                currentURL += `&filter=${text}`;
            }

            if (status) {
                currentURL += `&status=${status}`;
            }

            if (retorno) {
                currentURL += `&retorno=${retorno}`;
            }

            if (vendedor) {
                currentURL += `&vendedor=${vendedor}`;
            }

            // Redirecione para a nova URL
            window.location.href = currentURL;
        }


        const statusGet = urlParams.get('status');
        const retornoGet = urlParams.get('retorno');

        if (statusGet) {
            $('#select-filter-status').val(statusGet).trigger('change');
        }

        if (retornoGet) {
            $('#select-filter-retorno').val(retornoGet).trigger('change');
        }

        function orcamentoPorReferenciaContato() {

            if (!ref) {
                return;
            }

            $.ajax({
                method: 'GET',
                url: `${path_core}Contact.php?action=getInfoByIdAndProductsRetorno&id=${ref}`,
                dataType: 'json',
                success: function(res) {

                    console.log(res);

                    $('#btn-novo-orcamento').click();
                    $('#select-customers').val(res.data.cliente).trigger('change');
                    $('#pessoa-contato').val(res.data.contato)
                    $('#dialog-client').val(res.data.dialogo);

                    if (res.data.files) {
                        const files = JSON.parse(res.data.files);

                        files.forEach((file) => {
                            pond.addFile('assets/file/contacts/' + file);
                        });
                    }

                    const qtd = res.produtos.length;

                    res.produtos.forEach((produto, index) => {

                        $('.select-product:last').val(produto.id_produto_retornado).trigger('change');
                        $('.select-personalizacao:last').val(produto.id_produto_retornado).trigger('change');
                        $('.qtd-produto:last').val(produto.qtd_solicitado);
                        $('.qtd-mao-obra:last').val(produto.qtdServicoRetornado);
                        $('.select-personalizacao:last').val(produto.idPersonalizacaoRetornado).trigger('change');

                        if (index < qtd - 1) {
                            $('#new-product-budget').click();
                        }
                    });
                },
                error: function(xhr) {
                    console.log(xhr);
                }
            });
        }
        orcamentoPorReferenciaContato();

        function getUsuarios() {
            $.ajax({
                method: 'GET',
                url: `${path_core}User.php?action=getUsers`,
                dataType: 'JSON',
                success: (data) => {
                    let html = '<option value="">Todos os vendedores</option>';

                    data.forEach((user) => {
                        html += `<option value="${user.id}">${user.nome}</option>`;
                    });

                    $('#tipo-filter-vendedor').html(html);

                    if (urlParams.has('vendedor')) {
                        $('#tipo-filter-vendedor').val(urlParams.get('vendedor'));
                    }
                },
                error: (xhr) => {
                    console.log(xhr);
                }
            });
        }
        getUsuarios();

        function activeCheckboxValorManual() {
            $('.checkbox-valor-manual:last').on('change', function() {
                if ($(this).is(':checked')) {
                    $(this).parent().parent().find('.valor-manual').attr('disabled', false);
                    return;
                }

                $(this).parent().parent().find('.valor-manual').attr('disabled', true);
            });
        }
        activeCheckboxValorManual();

        function editaDataRetorno(id) {
            $('#id-edit-data-retorno').val(id);
            $('#title-edit-data-retorno').text('Editar data de retorno - #' + id);
            $('#modal-edit-data-retorno').modal('show');
        }

        $('#btn-save-data-retorno').on('click', function() {
            const id = $('#id-edit-data-retorno').val();
            const dataRetorno = $('#data-edit-data-retorno').val();

            $(this).attr('disabled', true);
            
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}Orcamentos.php`,
                data: {
                    action: 'updateDataRetorno',
                    idOrcamento: id,
                    dataRetorno: dataRetorno
                },
                success: function(data) {
                    console.log(data);
                    fat_alert({
                        type: 'primary',
                        title: 'Sucesso!',
                        message: 'Data de retorno atualizada com sucesso!',
                        timer: 2500
                    });
                    $('#modal-edit-data-retorno').modal('hide');
                    location.reload();
                },
                error: function(xhr) {
                    fat_alert({
                        type: 'danger',
                        title: 'Oops...',
                        message: 'Erro ao atualizar data de retorno!',
                        timer: 4000
                    });
                }
            });
        });
    </script>

</body>

</html>