<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Usuários atribuidos</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container,
        .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }
    </style>
    <!-- Helpers -->
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper ">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <!-- <div class="d-flex">
                                    <h5>Adicionar novo</h5>
                                    <button disabled type="button"
                                            class="btn w-px-20 h-px-20 rounded-pill btn-icon btn-outline-secondary ms-1"
                                            title="Cadastrar novo código" data-bs-toggle="modal" data-bs-target="#modal-new-code">
                                        <span class="tf-icons bx bx-plus"></span>
                                    </button>
                                </div> -->
    
                                <div>
                                    <button type="button"
                                            class="btn w-px-20 h-px-20 rounded-pill btn-icon btn-outline-secondary ms-1"
                                            title="Adicionar usuário ao código" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#modal-adiciona-usuario-codigo">
                                        <span class="tf-icons bx bx-plus"></span>
                                    </button>
                                </div>
                                <div>
                                    <h6 id="nomeAgrupadorCodigo"></h6>
                                </div>
                                <div><u><a href="code.php">Voltar</a></u></div>

                            </div>
                        </div>
                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Adicionado em</th>
                                    <th class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="table-code-info">
                                    <tr>
                                        <td colspan="3" class="text-center">Carregando...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<div class="modal fade" id="modal-adiciona-usuario-codigo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar novo código</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="form-group mb-0">
                    <label for="" class="form-label">Usuários</label>
                    <select id="select-user" class="form-select">
                        <?php foreach((new App\Core\User)->getNameAndId() as $user): ?>
                            <option value="<?= $user['id'] ?>"><?= $user['nome'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary d-flex" id="btn-add-usuario-code">
                    Cadastrar
                </button>
            </div>
        </div>
    </div>
</div>
<?php
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/select2/select2.min.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/vendor/fattos/alert.js"></script>

<!-- <script src="assets/js/fees.js"></script> -->
<script src="assets/js/helpers.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script>



    const obterParametroDaURL = (parametro) => {
        const urlSearchParams = new URLSearchParams(window.location.search);
        return urlSearchParams.get(parametro);
    };

    function s() {
        fat_alert({
            type: 'dark',
            title: 'Oops...',
            message: 'Recurso em implementação',
            timer: 5000
        });
    }
    
    const path_core = '../app/Core/';

    async function show() {
        return await $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Codigos.php?action=showUsers&id=${obterParametroDaURL('id')}`,
        });
    }

    $('#btn-add-usuario-code').on('click', function() {
        $('#btn-add-usuario-code').attr('disabled', true);
        const idCode = obterParametroDaURL('id');
        const idUser = $('#select-user').val();

        $.ajax({
            type: 'POST',
            url: `${path_core}Codigos.php`,
            dataType: 'JSON',
            data: {
                action: 'adicionaUsuarioCodigo',
                codigo: idCode,
                usuario: idUser
            },
            success: function () {
                fat_alert({
                    type: 'primary',
                    title: 'Sucesso!!!',
                    message: 'Usuário adicionado ao código',
                    timer: 5000
                });

                $('#btn-add-usuario-code').attr('disabled', false);
                $('#modal-adiciona-usuario-codigo').modal('hide');
                setTimeout(() => {
                    location.reload();
                }, 2000);
            },
            error: function (xhr) {
                console.log(xhr);

                const message = xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um problema ao atualizar o código';
                fat_alert({
                    type: 'danger',
                    title: 'Oops!',
                    message: message,
                    timer: 3000
                });

                $('#btn-add-usuario-code').attr('disabled', false);

            }
        });

    })

    function renderInfoTable(data) {

        let html = '';

        if (data == '') {
            html += `
                <tr>
                    <td colspan="2" class="text-center"><small>Nenhum registro encontrado... 🤔</small></td>
                </tr>
            `;

            fat_alert({
                type: 'dark',
                title: 'Hey!!!',
                message: 'Que tal criar seu primeiro código personalizado? 🤓',
                timer: 5000
            });

            setTimeout(() => {                
                fat_alert({
                    type: 'dark',
                    title: 'Vamos lá? 💡',
                    message: 'Clique no botão "+" ao lado de "Códigos" para começar... ',
                    timer: 5000
                });
            }, 5000);
        }

        data.forEach(el => {
            htmlOtions = `
                <button class="btn btn-sm btn-danger" type="button" onclick="removeUser(${el.id}, '${el.nome}')">Remover</button>
            `;

            html += `
                <tr id='ref-line-${el.id}'>
                    <td>${el.nome}</td>
                    <td>${el.data_criacao}</td>
                    <td class="text-center">${htmlOtions}</td>
                </tr>
            `;
        });

        $('#table-code-info').html(html)
    }

    show().then(
        (response) => renderInfoTable(response)
    ).catch(
        (error) => console.log(error)
    );

    function removeUser(idUsuario, nome) {
        const idCode = obterParametroDaURL('id');

        $.ajax({
            type: 'POST',
            url: `${path_core}Codigos.php`,
            data: {
                action: 'removeUser',
                idUsuario: idUsuario,
                id: idCode
            },
            success: function () {
                fat_alert({
                    type: 'primary',
                    title: 'Sucesso!!!',
                    message: `${nome} removido deste código agrupador de produtos`,
                    timer: 5000
                });

                $(`#ref-line-${idUsuario}`).remove();
            },
            error: function (xhr) {
                fat_alert({
                    type: 'danger',
                    title: 'Oops!',
                    message: 'Ocorreu um problema ao atualizar o código',
                    timer: 3000
                });
                console.log(xhr);
            }
        });
    }
    const getUsers = () => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}User.php`,
                data: {
                    action: 'getNameAndId'
                },
                success: function (data) {
                    resolve(data);
                },
                error: function (xhr) {
                    reject(xhr);
                }
            });
        });
    };
        
    async function getNomeAgrupadorCodigo() {
        return await $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Codigos.php?action=getNomeAgrupador&id=${obterParametroDaURL('id')}`,
        });
    }

    getNomeAgrupadorCodigo().then((nomeAgrupador) =>  {
        $('#nomeAgrupadorCodigo').text(nomeAgrupador);
    })


</script>

</body>

</html>