<!DOCTYPE html>

<html lang="pt-br" class="menu-inner py-1 over scroll" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Documentação/Guia de uso</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
            href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
            rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>
    <link rel="stylesheet" href="assets/css/demo.css"/>
    <link rel="stylesheet" href="assets/css/send-email-support.css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>
    <link rel="stylesheet" href="assets/vendor_template/libs/apex-charts/apex-charts.css"/>
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css"/>

    <!-- Page CSS -->
    <link rel="stylesheet" href="assets/css/dynamic-button-paginate.css">

    <!-- Helpers -->
    <script src="assets/vendor_template/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper ">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y ">
                        <div class="container light-mode-solid rounded">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="mt-3">Documentação</h3>
                                    <div class="row">
                                        <nav class="col-md-3 col-lg-2 d-md-block sidebar mt-2">
                                            <div id="navbar-guide-use" class="sidebar-sticky">
                                                <ul class="nav flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" href="#user-documentation">Usuários</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#customer-documentation">Clientes</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#product-documentation">Produtos</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#orcamentos-documentation">Orçamentos</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#fees-documentation">Juros</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#tax-documentation">Taxas</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#costs-documentation">Custos</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="#support-documentation">Suporte</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" href="documentation.php">Voltar</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </nav>
                                        <div class="col-md-12 col-lg-10 mt-3">
                                            <h4 id="user-documentation"><b>Usuários</b></h4>
                                            <h5>Criação de Usuários</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Usuários" para ser redirecionado à página de criação de usuários.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as seguintes informações: foto do usuário, nome, e-mail, nível de acesso, status e ações.</li>
                                                <li>No topo da página de usuários, há um botão de adição (+). Clique nele para abrir uma janela de criação de usuário.</li>
                                                <li>Na janela de criação, é necessário preencher as seguintes informações:</li>
                                                <ul>
                                                    <li><strong>Nível de acesso:</strong> selecione o nível de acesso do usuário. Pode ser "comercial" ou "administrador".</li>
                                                    <li><strong>Nome completo:</strong> digite o nome completo do usuário.</li>
                                                    <li><strong>E-mail:</strong> insira o endereço de e-mail do usuário.</li>
                                                    <li><strong>Senha:</strong> defina uma senha para o usuário.</li>
                                                    <li><strong>Repetir senha:</strong> repita a senha para confirmar.</li>
                                                    <li><strong>Foto do usuário (opcional):</strong> é possível adicionar uma foto do usuário, mas esse campo é opcional.</li>
                                                </ul>
                                                <li>Todos os campos marcados com "*" são obrigatórios, exceto a foto do usuário. Após preencher todos os campos, clique no botão "Cadastrar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/createUser.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="add-user">
                                            <br><br>
                                            <h5>Edição de Usuários</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de usuários, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas três opções: Editar, Inativar e Alterar Senha. Selecione "Editar".</li>
                                                <li>Isso abrirá uma janela de edição do usuário, onde você poderá fazer as alterações necessárias.</li>
                                                <li>Lembre-se de que todos os campos marcados com "*" são obrigatórios.</li>
                                                <li>Após fazer as alterações desejadas, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/editUser.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-user">
                                            <br><br>
                                            <h5>Inativação/Ativação de Usuários</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de usuários, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas três opções: Editar, Inativar e Alterar Senha. Selecione "Inativar".</li>
                                                <li>Isso abrirá uma janela de inativação do usuário, onde você poderá desativar ou reativar um usuário.</li>
                                                <li>Após confirmar a alteração do status do usuário, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/changeStatusUser.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="change-status-user">
                                            <br><br>
                                            <h5>Alterar senha de Usuários</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de usuários, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas três opções: Editar, Inativar e Alterar Senha. Selecione "Alterar Senha".</li>
                                                <li>Isso abrirá uma janela de alteração de senha.</li>
                                                <li>Preencha o campo da nova senha e confirme-a. Lembre-se de que a senha deve conter pelo menos 6 caracteres.</li>
                                                <li>Após preencher os campos, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/changePassword.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="change-password-user">

                                            <br><br>

                                            <h4 id="customer-documentation"><b>Clientes</b></h4>
                                            <h5>Criação de Clientes</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Clientes" para ser redirecionado à página de criação de clientes.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as seguintes informações: nome, e-mail, CPF/CNPJ, telefone, celular, link social, rede social, status e ações.</li>
                                                <li>No topo da página de clientes, há um botão de adição (+). Clique nele para abrir uma janela de criação de cliente.</li>
                                                <li>Na Janela de criação, é necessário preencher as seguintes informações:</li>
                                                <ul>
                                                    <li><strong>Checkbox:</strong> selecione se é CPF ou CNPJ.</li>
                                                    <li><strong>Telefone (opcional):</strong> insira o número de telefone (opcional).</li>
                                                    <li><strong>E-mail:</strong> insira o endereço de e-mail.</li>
                                                    <li><strong>Celular (opcional):</strong> insira o número de celular (opcional).</li>
                                                    <li><strong>CPF ou CNPJ (opcional):</strong> insira o número do CPF ou CNPJ (opcional).</li>
                                                    <li><strong>CEP:</strong> preenchido automaticamente ao digitar um CEP válido (opcional).</li>
                                                    <li><strong>Bairro (opcional):</strong> insira o bairro (opcional).</li>
                                                    <li><strong>Endereço (opcional):</strong> insira o endereço (opcional).</li>
                                                    <li><strong>Cidade (opcional):</strong> insira a cidade (opcional).</li>
                                                    <li><strong>Estado (opcional):</strong> insira o estado (opcional).</li>
                                                    <li><strong>Número (opcional):</strong> insira o número do endereço (opcional).</li>
                                                    <li><strong>Complemento (opcional):</strong> insira informações adicionais sobre o endereço (opcional).</li>
                                                    <li><strong>Regime Tributário:</strong> selecione o regime tributário.</li>
                                                    <li><strong>Inscrição estadual (opcional):</strong> insira o número da inscrição estadual (opcional).</li>
                                                    <li><strong>Rede social (opcional):</strong> insira informações sobre a rede social do cliente (opcional).</li>
                                                    <li><strong>Logo do cliente (opcional):</strong> adicione o logotipo do cliente, se necessário (opcional).</li>
                                                </ul>
                                                <li>Todos os campos marcados com "*" são obrigatórios. Após preencher todos os campos, clique no botão "Cadastrar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/createCustomer.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="create-customer">
                                            <br><br>
                                            <h5>Edição de Clientes</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de clientes, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Inativar. Selecione "Editar".</li>
                                                <li>Isso abrirá uma janela de edição do cliente, onde você poderá fazer as alterações necessárias.</li>
                                                <li>Lembre-se de que todos os campos marcados com "*" são obrigatórios.</li>
                                                <li>Após fazer as alterações desejadas, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/customerEdit.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-customer">

                                            <br><br>

                                            <h5>Inativação/Ativação de Clientes</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de clientes, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Inativar. Selecione "Inativar".</li>
                                                <li>Isso abrirá uma janela de inativação do cliente, onde você poderá desativar ou reativar um cliente.</li>
                                                <li>Após confirmar a alteração do status do cliente, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/changeStatusCustomer.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="change-status-customer">

                                            <br><br>

                                            <h4 id="product-documentation"><b>Produtos</b></h4>
                                            <h5>Criação de Produtos</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Produtos" para ser redirecionado à página de criação de produtos.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as seguintes informações: cód. produto, produto, valor un. (Custo), frete compra, mão de obra, embalagem, extras, valor un. (Venda), ações.</li>
                                                <li>No topo da página de produtos, há um botão de adição (+). Clique nele para abrir uma janela de criação de produtos.</li>
                                                <li>Na janela de produtos, é necessário preencher as seguintes informações:</li>
                                                <ul>
                                                    <li><strong>Código do produto:</strong> insira o código do produto.</li>
                                                    <li><strong>Embalagem:</strong> insira as informações sobre a embalagem.</li>
                                                    <li><strong>Valor unitário (custo):</strong> insira o valor de custo unitário do produto.</li>
                                                    <li><strong>Nome do produto:</strong> insira o nome do produto.</li>
                                                    <li><strong>Mão de obra:</strong> insira as informações sobre a mão de obra.</li>
                                                    <li><strong>Extras:</strong> insira informações adicionais sobre o produto.</li>
                                                    <li><strong>Descrição do produto (opcional):</strong> forneça uma descrição detalhada do produto (opcional).</li>
                                                    <li><strong>Frete compra:</strong> insira as informações sobre o frete de compra.</li>
                                                    <li><strong>Fotos do produto (opcional):</strong> adicione fotos do produto, se necessário.</li>
                                                </ul>
                                                <li>Todos os campos marcados com "*" são obrigatórios. Após preencher todos os campos, clique no botão "Cadastrar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/createProduct.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="create-product">
                                            <br><br>
                                            <h5>Edição de Produtos</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de produtos, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Excluir. Selecione "Editar".</li>
                                                <li>Isso abrirá uma janela de edição de produtos, onde você poderá fazer as alterações necessárias.</li>
                                                <li>Lembre-se de que todos os campos marcados com "*" são obrigatórios.</li>
                                                <li>Após fazer as alterações desejadas, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/editProduct.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-product">
                                            <br><br>
                                            <h5>Exclusão de Produtos</h5>
                                            <ol>
                                                <li>Na coluna "Ações" à direita da tabela de produtos, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Excluir. Selecione "Excluir".</li>
                                                <li>Isso abrirá uma janela de exclusão de produto.</li>
                                                <li>Lembre-se, uma vez excluído, o item não poderá ser recuperado.</li>
                                                <li>Após confirmar a exclusão do produto, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/deleteProduct.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="delete-product">

                                            <br><br>

                                            <div class="row">
                                                <div class="col-md-12 col-lg-6">
                                                    <h4 id="orcamentos-documentation"><b>Orçamentos</b></h4>
                                                    <h5>Criação de Orçamentos</h5>
                                                    <ol>
                                                        <li>A FAZER</li>
                                                    </ol>
                                                </div>
                                            </div>

                                            <br><br>

                                            <h4 id="fees-documentation"><b>Juros</b></h4>
                                            <h5>Criação de Juros</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Juros" para ser redirecionado à página de criação de juros.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as seguintes informações: prazo, juros e ações.</li>
                                                <li>No topo da página de juros, há um botão de adição (+). Clique nele para abrir uma janela de criação de juros.</li>
                                                <li>Na janela de juros, é necessário preencher as seguintes informações:</li>
                                                <ul>
                                                    <li><strong>Quantidade de vezes:</strong> insira a quantidade de vezes para os juros.</li>
                                                    <li><strong>Juros:</strong> insira a taxa de juros.</li>
                                                </ul>
                                                <li>Todos os campos marcados com "*" são obrigatórios. Após preencher todos os campos, clique no botão "Cadastrar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/createFees.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="create-fees">
                                            <br><br>
                                            <h5>Edição de Juros</h5>
                                            <ol>
                                                <li>Na coluna "ações" à direita da tabela de juros, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Excluir. Selecione "Editar".</li>
                                                <li>Isso abrirá uma janela de edição de juros, onde você poderá fazer as alterações necessárias.</li>
                                                <li>Lembre-se de que todos os campos marcados com "*" são obrigatórios.</li>
                                                <li>Após fazer as alterações desejadas, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/editFees.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-fees">
                                            <br><br>
                                            <h5>Exclusão de Juros</h5>
                                            <ol>
                                                <li>Na coluna "Ações" à direita da tabela de juros, há um botão representado pelo ícone <i class="bx bx-dots-vertical-rounded"></i>.</li>
                                                <li>Ao clicar nesse botão, serão exibidas duas opções: Editar e Excluir. Selecione "Excluir".</li>
                                                <li>Isso abrirá uma janela de exclusão de juros.</li>
                                                <li>Após confirmar a exclusão dos juros, clique no botão "Salvar".</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/deleteFees.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="delete-fees">

                                            <br><br>

                                            <h4 id="tax-documentation"><b>Taxas</b></h4>
                                            <h5>Criação de Taxas</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Taxas" para ser redirecionado à página de criação de taxas.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as seguintes informações: menor preço, condição ideal e preço com margem.</li>
                                                <li>Para criar uma taxa, preencha os seguintes campos:</li>
                                                <ul>
                                                    <li><strong>Menor Preço:</strong> insira o valor do menor preço.</li>
                                                    <li><strong>Condição Ideal:</strong> insira a condição ideal para a taxa.</li>
                                                    <li><strong>Preço com Margem:</strong> insira o preço com margem.</li>
                                                </ul>
                                                <li>Todos os campos marcados são obrigatórios. Certifique-se de preencher todos eles antes de prosseguir e clique no botão "Salvar".</li>
                                                <li>Você também pode alterar os valores existentes seguindo o mesmo processo.</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/editTax.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-tax">

                                            <br><br>

                                            <h4 id="costs-documentation"><b>Custos</b></h4>
                                            <h5>Criação de Custos</h5>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Custos" para ser redirecionado à página de criação de custos.</li>
                                                <li>Na página de criação, você verá uma tabela exibindo as informações a seguir: imposto, custo administrativo, comissão e desconto financeiro.</li>
                                                <li>Para criar os valores de custos, preencha os seguintes campos:</li>
                                                <ul>
                                                    <li><strong>Imposto:</strong> insira o valor do imposto.</li>
                                                    <li><strong>Custo Administrativo:</strong> insira o valor do custo administrativo.</li>
                                                    <li><strong>Comissão:</strong> insira o valor da comissão.</li>
                                                    <li><strong>Desconto Financeiro:</strong> insira o valor do desconto financeiro.</li>
                                                </ul>
                                                <li>Todos os campos marcados são obrigatórios. Certifique-se de preencher todos eles antes de prosseguir e clique no botão "Salvar".</li>
                                                <li>Você também pode alterar os valores existentes seguindo o mesmo processo.</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/editCosts.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="edit-costs">

                                            <br><br>

                                            <h4 id="support-documentation"><b>Suporte</b></h4>
                                            <h5>Criação de Ticket de Suporte</h5>
                                            <p>Para criar um ticket de suporte, siga estas etapas:</p>
                                            <ol>
                                                <li>No menu lateral esquerdo, clique em "Suporte" para ser redirecionado à página de criação de ticket.</li>
                                                <li>Na página de criação, você verá uma tabela com as informações: assunto, descrição, data de envio e ver mais.</li>
                                                <li>No topo da página de suporte, clique no botão de adição (+) para abrir uma janela de criação de ticket.</li>
                                                <li>No modal de criação, preencha os campos necessários, incluindo:</li>
                                                <ul>
                                                    <li><strong>Assunto:</strong> forneça um título breve e descritivo para o ticket.</li>
                                                    <li><strong>Descrição:</strong> explique detalhadamente o problema ou pergunta que você tem.</li>
                                                    <li><strong>Anexo de imagem (opcional):</strong> se necessário, você pode adicionar uma imagem relacionada ao ticket.</li>
                                                </ul>
                                                <li>Os campos "assunto" e "descrição" são obrigatórios. Certifique-se de preencher todos os campos necessários.</li>
                                                <li>Clique no botão "Enviar" para criar o ticket.</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/createTicketSupport.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="create-ticket-support">
                                            <br><br>
                                            <h5>Exibição do ticket de Suporte</h5>
                                            <ol>
                                                <li>Na coluna "Ver mais" à direita da tabela de tickets de suporte, você encontrará um botão representado pelo ícone <i class="bx bx-show"></i>.</li>
                                                <li>Ao clicar nesse botão, uma janela será aberta, exibindo os detalhes do ticket selecionado.</li>
                                            </ol>
                                            <p>Aqui está uma imagem demonstrativa do processo:</p>
                                            <img src="assets/file/documentation/gifs/showTicketSupport.gif" class="img-fluid rounded" style="width: 1000px; height: auto;" alt="show-ticket-support">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-backdrop fade"></div>
            </div>
        </div>
    </div>
</body>
<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_show_image.html';
?>
<!-- / Modals -->

<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor_template/js/menu.js"></script>
<script src="assets/vendor/select2/select2.min.js"></script>
<!-- endbuild -->

<!-- vendor_templates JS -->
<script src="assets/vendor_template/libs/apex-charts/apexcharts.js"></script>

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script src="assets/js/dashboards-analytics.js"></script>
<script src="assets/js/customer.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
<script src="assets/js/support.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>
<script>
    $(document).ready(function() {
        $(window).scroll(function() {
            const scrollPosition = $(window).scrollTop();

            $('#navbar-guide-use').removeClass('fixed-nav-guide');

            if (scrollPosition > $('#navbar-guide-use').offset().top) {
                $('#navbar-guide-use').addClass('fixed-nav-guide');
            }
            if (scrollPosition > $('#scroll-fixed-sidebar').offset().top) {
                $('#scroll-fixed-sidebar').addClass('fixed-nav-guide');
            }
        });
    });
</script>