
<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Produtos</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
            href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
            rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>


    <!-- Page CSS -->
    <link rel="stylesheet" href="assets/css/upload-image.css"/>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container control-dark-mode dark-mode light-mode">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <h5 class="card-header d-flex justify-content-between">
                        <?php if ((int)$_SESSION['user']['nivel'] > 7): ?>
                            
                        <div>
                            Produtos
                            <button type="button"
                                    class="btn w-px-17 h-px-17 mb-1 rounded-pill btn-icon btn-outline-primary"
                                    title="Cadastrar novo usuário" data-bs-toggle="modal"
                                    data-bs-target="#modal-new-product">
                                <span class="tf-icons bx bx-xs bx-plus"></span>
                            </button>
                        </div>   
                        
                        <?php endif; ?>

                            <div class="d-flex h-px-30">
                                <input class="form-control me-1" type="text" name="" value="<?= $_GET['filter'] ?? '' ?>" id="text-filter-product" placeholder="Buscar...">
                                <button class="btn btn-sm btn-primary" id="btn-filter-product">Buscar</button>
                            </div>
                        </h5>
                        <?php
                        $product = new App\Core\Product;

                        $filter = $_GET['filter'] ?? '';
                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $limit_per_page = 10;

                        $paginate_views_product = $product->show($current_page, $limit_per_page, $filter);
                        ?>

                        <div class="table-responsive text-nowrap">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="w-px-10">#</th>
                                        <th class="w-px-10">Cód.</th>
                                        <th>Produto</th>
                                        <th>Categoria</th>
                                        <th class="text-center">EM Estoque</th>
                                        <?php if ((int)$_SESSION['user']['nivel'] > 7): ?>
                                        <th class="w-px-200 text-end" title="Valor do custo unitário">Valor Aquisição</th>
                                        <th class="w-50-px text-end">Mão de obra</th>
                                        <th class="w-50-px text-end">Embalagem</th>
                                        <th class="w-50-px text-end">Extras</th>
                                        <th class="w-50-px text-end">Frete compra</th>
                                        <th class="w-10-px">Ações</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">

                                <?php 

                                $lista_produtos = $paginate_views_product['data'];

                                if (empty($lista_produtos)) {
                                    echo "<tr><td colspan='10' class='text-center'>Nada encontrado... 🙁</td></tr>";
                                }

                                foreach ($lista_produtos as $key => $value): 
                                    if ($value['visible'] === 1):
                                        $class_foto = !$value['foto'] ? 'pulse-product' : '';
                                        $product_foto = $value['foto'] ? explode(',', $value['foto']) : [''];
                                        $view_name = !empty($value['observacao']) ? $value['nome'] . ' ('. $value['observacao'] . ')' : $value['nome'];

                                        $frete_compra_view = $value['frete_compra_regra'] > 0
                                            ? 'R$ '. number_format($value['frete_compra'], 2, ',', '.') . ' <strong>/</strong> '. $value['frete_compra_regra']
                                            : 'R$ '. number_format($value['frete_compra'], 2, ',', '.');

                                        $mao_obra_view = $value['mao_obra_regra'] > 0 
                                            ? 'R$ '. number_format($value['mao_obra'], 2, ',', '.') . ' <strong>/</strong> R$ '. number_format($value['mao_obra_regra'], 2, ',', '.') 
                                            : 'R$ '. number_format($value['mao_obra'], 2, ',', '.');

                                        $embalagem_view = $value['embalagem_regra'] > 0 
                                            ? 'R$ '. number_format($value['embalagem'], 2, ',', '.') . ' <strong>/</strong> '. $value['embalagem_regra'] 
                                            : 'R$ '. number_format($value['embalagem'], 2, ',', '.');

                                        $td_attr_name_product = strlen($view_name) > 24 ? "
                                            class='c-h'
                                            data-bs-toggle='tooltip' 
                                            data-bs-placement='top'
                                            data-bs-html='true'
                                            title='$view_name'" : '';

                                        $name_product = strlen($view_name) > 24 ? substr($view_name, 0, 24) . '... <i class="bx bx-xs bx-copy-alt c-p" onclick="copyToClipboard(\'' . $view_name . '\')" data-bs-placement="bottom" data-bs-toggle="tooltip" title="Clique para copiar o nome completo do produto"></i>' : $view_name; 
                                        ?>

                                        <tr data-tr-product-id="<?= $value['id'] ?>">
                                            <td>
                                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-xs pull-up">
                                                        <img src='assets/file/product/<?= $product_foto[0] ?>' onclick="showImage(this.src)" onerror='this.src="assets/file/system/undraw_product.svg"' class='avatar avatar-xs pull-up rounded-circle <?= $class_foto ?>'>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td><?= $value['id'] ?></td>
                                            <td <?= $td_attr_name_product ?> data-completed-name="<?= $view_name ?>"> <?= $name_product  ?></td>
                                            <td> <?= $value['categoria'] ?? '<span class="text-danger"><small><u>Pendente</u></small></span>' ?></td>
                                            <td class="text-center">
                                                <?php 
                                                    $classEstoque = $value['qtdEmEstoque'] < 0 ? 'text-danger' : 'text-primary';
                                                ?>
                                                <label class="<?= $classEstoque ?> c-p fw-bold" onclick="visualizaEstoque(<?= $value['id'] ?>)"> 
                                                    <?= $value['qtdEmEstoque'] ?>
                                                </label>
                                            </td>
                                            <?php if ((int)$_SESSION['user']['nivel'] > 7): ?>

                                            <td class="text-end">R$ <?= number_format($value['valor_compra'], 2, ',', '.') ?></td>
                                            <td class="text-end"><?= $mao_obra_view ?></td>
                                            <td class="text-end"><?= $embalagem_view ?></td>
                                            <td class="text-end">R$ <?= number_format($value['extras'], 2, ',', '.') ?></td>
                                            <td class="text-end"><?= $frete_compra_view ?></td>
                                            <td>
                                                <div class="dropdown dropstart">
                                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" onclick="showModalEditProduct('<?= $value['id'] ?>')" href="javascript:void(0);">
                                                            <i class="bx bx-edit-alt me-1"></i>Editar
                                                        </a>
                                                        <a class="dropdown-item" onclick="modalShowDeleteProduct('<?= $value['id'] ?>', '<?= $value['nome'] ?>', '<?= $value['visible'] ?>')" href="javascript:void(0);">
                                                            <i class="bx bx-trash me-1"></i>Excluir
                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endif; 
                                endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th class="w-px-10">#</th>
                                        <th class="w-px-10">Cód.</th>
                                        <th>Produto</th>
                                        <th>Categoria</th>
                                        <?php if ((int)$_SESSION['user']['nivel'] > 7): ?>
                                        <th class="text-center">Em Estoque</th>
                                        <th class="w-px-200 text-end" title="Valor do custo unitário">Valor Aquisição</th>
                                        <th class="w-50-px text-end">Mão de obra</th>
                                        <th class="w-50-px text-end">Embalagem</th>
                                        <th class="w-50-px text-end">Extras</th>
                                        <th class="w-50-px text-end">Frete compra</th>
                                        <th class="w-10-px">Ações</th>
                                        <?php endif; ?>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                            <?php
                            if ($lista_produtos) {
                                echo '<div class="dynamic-pagination col text-center my-3 ">' . $paginate_views_product['pages'] . '</div>';
                            }
                            ?>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/product/modal_create_product.html';
include __DIR__ . '/partials/modal/product/modal_edit_product.html';
include __DIR__ . '/partials/modal/product/modal_delete_product.html';
include __DIR__ . '/partials/modal/modal_show_image.html';
?>
<!-- / Modals -->

<div class="modal fade" id="modal-visualiza-estoque" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title" id="movimentacaoEstoqueTitle">Movimentação de estoque</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>O.S</th>
                                <th>Qtd Uso</th>
                                <th>Qtd Compra</th>
                                <th>Valor un</th>
                                <th class="text-center">Cliente</th>
                                <th>Data entrada</th>
                            </tr>
                        </thead>
                        <tbody id="modal-estoque-produto-tbody">
                            <tr>
                                <td colspan="6">Carregando...</td>
                            </tr>
                        </tbody>
                        <tfoot id="modal-estoque-produto-tfoot">
                            <tr>
                                <td><strong>0</strong></td>
                                <td><strong>0</strong></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <?php if ((int)$_SESSION['user']['nivel'] === 9): ?>
                <button type="button" class="btn btn-sm btn-label-primary" data-bs-toggle="modal" data-bs-target="#modal-entrada-estoque">
                    <i class="bx bx-package"></i> Manipulação manual do estoque 
                </button>
                <?php endif; ?>
                <button type="button" class="btn btn-sm btn-label-secondary" data-bs-dismiss="modal"><i class="bx bx-exit"></i> Fechar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-entrada-estoque" role="dialog" aria-labelledby="modalEntradaEstoqueTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title" id="modalEntradaEstoqueTitle">Entrada/saída manual de estoque</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="form-group">
                            <label class="form-label">Qtd uso *</label>
                            <input type="number" class="form-control" id="qtd-uso" min="0">
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-2 col-6">
                        <div class="form-group">
                            <label class="form-label">Qtd compra * </label>
                            <input type="number" class="form-control" id="qtd-compra" min="0">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-6">
                        <div class="form-group">
                            <label class="form-label">Valor Unitário</label>
                            <input type="text" class="form-control" id="valor" name="valor">
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-6">
                        <div class="form-group">
                            <label for="cliente" class="form-label">Data entrada</label>
                            <input type="date" class="form-control" id="data-entrada" name="data-entrada">
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-label-primary disabled" disabled>Salvar</button>
            </div>
        </div>
    </div>
</div>


<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/js/product.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/vendor/maskMoney/jquery.maskMoney.min.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>

<script>

    var produtoIdManipulaEstoque = null;
    function visualizaEstoque(id) {

        produtoIdManipulaEstoque = id;

        const productName = $(`tr[data-tr-product-id="${id}"] > td[data-completed-name]`).data('completed-name');

        $('#movimentacaoEstoqueTitle').text(`Movimentação de estoque: ${productName}`);
        $('#modalEntradaEstoqueTitle').text(`Entrada/saída manual de estoque: ${productName}`);
        
        $.ajax({
            method: 'POST',
            url: `${path_core}Product.php?action=getEstoqueProduto`,
            data: {id: id},
            dataType: 'JSON',
            success: function(response) {

                if (response.length === 0) {
                    $('#modal-estoque-produto-tbody').html('<tr><td colspan="6" class="text-center">Nenhum registro encontrado...</td></tr>');
                    $('#modal-estoque-produto-tfoot').html(`
                        <tr class="text-center">
                            <td> - </td>
                            <td> - </td>
                            <td> - </td>
                            <td> - </td>
                            <td> - </td>
                            <td> - </td>
                        </tr>`);
                    $('#modal-visualiza-estoque').modal('show');
                    return;
                }

                let html = '';
                let totalUtilizado = 0;
                let totalComprado = 0;
                response.forEach(el => {
                    const ptBRmoney = new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' });
                    const money = ptBRmoney.format(el.valor_un);

                    html += `
                        <tr>
                            <td>#${el.id_ordem_servico}</td>
                            <td>${el.qtd}</td>
                            <td>${el.qtd_comprada}</td>
                            <td>${money}</td>
                            <td>${el.cliente}</td>
                            <td>${el.previsao_chegada}</td>
                        </tr>
                    `;

                    totalUtilizado += parseInt(el.qtd);
                    totalComprado += parseInt(el.qtd_comprada);
                });

                const htmlTfoot = `
                    <tr>
                        <td></td>
                        <td><strong>${totalUtilizado}</strong></td>
                        <td><strong>${totalComprado}</strong></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                `;

                $('#modal-estoque-produto-tbody').html(html);
                $('#modal-estoque-produto-tfoot').html(htmlTfoot);
                $('#modal-visualiza-estoque').modal('show');
            },
            error: function(err) {
                console.log(err);
            }
        })
    }


    async function getCategoriasProduto() {
        return await $.ajax({
            method: 'GET',
            url: `${path_core}Codigos.php?action=getCodigos`,
            dataType: 'JSON'
        })
    }

    getCategoriasProduto().then(response => {
        let htmlOptions = '';

        response.forEach(el => {
            htmlOptions += `<option value='${el.id}'>${el.nome}</option>`;
        });

        $('#modal-create-product-categoria, #modal-edit-product-categoria').html(htmlOptions)
    })


    function copyToClipboard(copyText) {
        navigator.clipboard.writeText(copyText);
        fat_alert({
            type: 'dark',
            title: 'Texto copiado',
            message: copyText,
            timer: 2500
        });
    }

    const btnAddRegraValorCusto = $('#btn-add-rule-valor-custo');
    const btnRemoveRegraValorCusto = $('#btn-remove-rule-valor-custo');
    const divRegraValorCusto = $('#div-regra-valor-custo');

    btnAddRegraValorCusto.on('click', function() {
        btnAddRegraValorCusto.removeClass('cursor-pointer');
        btnAddRegraValorCusto.children().addClass('d-none');
        divRegraValorCusto.removeClass('d-none');
    });

    btnRemoveRegraValorCusto.on('click', function() {
        divRegraValorCusto.addClass('d-none');
        btnAddRegraValorCusto.addClass('cursor-pointer');
        btnAddRegraValorCusto.children().removeClass('d-none');
        $('#modal-create-product-regra-valor-compra-un-custo').val('');
    });

    // ------------------------------------------------------------------------

    // const btnAddRegraMaoObra = $('#btn-add-rule-mao-obra');
    // const btnRemoveRegraMaoObra = $('#btn-remove-rule-mao-obra');
    // const divRegraMaoObra = $('#div-regra-mao-obra');

    // btnAddRegraMaoObra.on('click', function() {
    //     btnAddRegraMaoObra.removeClass('cursor-pointer');
    //     btnAddRegraMaoObra.children().addClass('d-none');
    //     divRegraMaoObra.removeClass('d-none');
    // });

    // btnRemoveRegraMaoObra.on('click', function() {
    //     divRegraMaoObra.addClass('d-none');
    //     btnAddRegraMaoObra.addClass('cursor-pointer');
    //     btnAddRegraMaoObra.children().removeClass('d-none');
    //     $('#modal-create-product-regra-mao-obra').val('');
    // });

    //-------------------------------------------------------------------------

    const btnAddRegraEmbalagem = $('#btn-add-rule-embalagem');
    const btnRemoveRegraEmbalagem = $('#btn-remove-rule-embalagem');
    const divRegraEmbalagem = $('#div-regra-embalagem');

    btnAddRegraEmbalagem.on('click', function() {
        btnAddRegraEmbalagem.removeClass('cursor-pointer');
        btnAddRegraEmbalagem.children().addClass('d-none');
        divRegraEmbalagem.removeClass('d-none');
    });

    btnRemoveRegraEmbalagem.on('click', function() {
        divRegraEmbalagem.addClass('d-none');
        btnAddRegraEmbalagem.addClass('cursor-pointer');
        btnAddRegraEmbalagem.children().removeClass('d-none');
        $('#modal-create-product-regra-embalagem').val('');
    });

    //------------------------------------------------------------------------

    const btnAddRegraFreteCompra = $('#btn-add-rule-frete-compra');
    const btnRemoveRegraFreteCompra = $('#btn-remove-rule-frete-compra');
    const divRegraFreteCompra = $('#div-regra-frete-compra');

    btnAddRegraFreteCompra.on('click', function() {
        btnAddRegraFreteCompra.removeClass('cursor-pointer');
        btnAddRegraFreteCompra.children().addClass('d-none');
        divRegraFreteCompra.removeClass('d-none');
    });

    btnRemoveRegraFreteCompra.on('click', function() {
        divRegraFreteCompra.addClass('d-none');
        btnAddRegraFreteCompra.addClass('cursor-pointer');
        btnAddRegraFreteCompra.children().removeClass('d-none');
        $('#modal-create-product-regra-frete-compra').val('');
    });

    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })


    // Edit section
    // ------------------------------------------------------------------------

    // const btnEditRegraMaoObra = $('#btn-edit-rule-mao-obra');
    // const btnEditRemoveRegraMaoObra = $('#btn-remove-edit-rule-mao-obra');
    // const divEditRegraMaoObra = $('#div-edit-regra-mao-obra');

    // btnEditRegraMaoObra.on('click', function() {
    //     btnEditRegraMaoObra.removeClass('cursor-pointer');
    //     btnEditRegraMaoObra.children().addClass('d-none');
    //     divEditRegraMaoObra.removeClass('d-none');
    // });

    // btnEditRemoveRegraMaoObra.on('click', function() {
    //     divEditRegraMaoObra.addClass('d-none');
    //     btnEditRegraMaoObra.addClass('cursor-pointer');
    //     btnEditRegraMaoObra.children().removeClass('d-none');
    //     $('#modal-edit-product-regra-mao-obra').val('');1
    // });

    //-------------------------------------------------------------------------

    const btnEditRegraEmbalagem = $('#btn-edit-rule-embalagem');
    const btnEditRemoveRegraEmbalagem = $('#btn-remove-edit-rule-embalagem');
    const divEditRegraEmbalagem = $('#div-edit-regra-embalagem');

    btnEditRegraEmbalagem.on('click', function() {
        btnEditRegraEmbalagem.removeClass('cursor-pointer');
        btnEditRegraEmbalagem.children().addClass('d-none');
        divEditRegraEmbalagem.removeClass('d-none');
    });

    btnEditRemoveRegraEmbalagem.on('click', function() {
        divEditRegraEmbalagem.addClass('d-none');
        btnEditRegraEmbalagem.addClass('cursor-pointer');
        btnEditRegraEmbalagem.children().removeClass('d-none');
        $('#modal-edit-product-regra-embalagem').val('');
    });

    //------------------------------------------------------------------------

    const btnEditRegraFreteCompra = $('#btn-edit-rule-frete-compra');
    const btnEditRemoveRegraFreteCompra = $('#btn-remove-edit-rule-frete-compra');
    const divEditRegraFreteCompra = $('#div-edit-regra-frete-compra');

    btnEditRegraFreteCompra.on('click', function() {
        btnEditRegraFreteCompra.removeClass('cursor-pointer');
        btnEditRegraFreteCompra.children().addClass('d-none');
        divEditRegraFreteCompra.removeClass('d-none');
    });

    btnEditRemoveRegraFreteCompra.on('click', function() {
        divEditRegraFreteCompra.addClass('d-none');
        btnEditRegraFreteCompra.addClass('cursor-pointer');
        btnEditRegraFreteCompra.children().removeClass('d-none');
        $('#modal-edit-product-regra-frete-compra').val('');
    });
</script>
</body>

</html>