<?php use App\Core\Helpers\Helper as Helpers; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Perfil</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>
    <link rel="stylesheet" href="assets/css/demo.css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>
    <link rel="stylesheet" href="assets/vendor_template/libs/apex-charts/apex-charts.css"/>

    <!-- Page CSS -->
    <link rel="stylesheet" href="assets/css/dynamic-button-paginate.css"/>

    <!-- Helpers -->
    <script src="assets/vendor_template/js/_helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <h5 class="card-header">Suas informações</h5>
                                    <!-- Account -->
                                    <div class="card-body">
                                        <div class="d-flex align-items-start align-items-sm-center gap-4">
                                            <img data-user-img='<?= $_SESSION['user']['img'] ?>' id="profile-image-show"
                                                 class="d-block rounded border" height="100"
                                                 width="100" <?= "src='assets/file/user/{$_SESSION['user']['img']}'" ?>
                                                 onerror='this.src="assets/file/system/undraw_profile.svg"'>

                                            <div class="button-wrapper">
                                                <label for="upload" class="btn btn-primary me-2 mb-4" tabindex="0">
                                                    <span class="d-none d-sm-block">Atualizar foto</span>
                                                    <i class="bx bx-upload d-block d-sm-none"></i>
                                                    <input type="file" id="upload"
                                                           class="account-file-input profile-image" hidden
                                                           accept="image/png, image/jpeg"/>
                                                </label>
                                                <button type="button" onclick="resetInputs()"
                                                        class="btn btn-outline-secondary account-image-reset mb-4">
                                                    <i class="bx bx-reset d-block d-sm-none"></i>
                                                    <span class="d-none d-sm-block">Limpar</span>
                                                </button>

                                                <p class="text-muted mb-0">Apenas JPG, GIF ou PNG. Tamanho máximo
                                                    1MB</p>
                                            </div>

                                        </div>
                                    </div>
                                    <hr class="my-0"/>
                                    <div class="card-body">
                                        <form id="formAccountSettings" method="POST" onsubmit="return false">
                                            <div class="row">
                                                <div class="mb-3 col-md-6">
                                                    <label for="firstName" class="form-label">Nome</label>
                                                    <input class="form-control" type="text" id="profile-name"
                                                           name="firstName" value="<?= Helpers::getFirstName(); ?>"
                                                           autofocus/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="lastName" class="form-label">Sobrenome</label>
                                                    <input class="form-control" type="text" name="profile-last-name"
                                                           id="profile-last-name"
                                                           value="<?= Helpers::getLastName() ?>"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="email" class="form-label">E-mail</label>
                                                    <input disabled class="form-control c-n" type="text"
                                                           id="profile-email" name="email"
                                                           value="<?= $_SESSION['user']['email']; ?>"
                                                           placeholder="john.doe@example.com"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="organization" class="form-label">Empresa</label>
                                                    <input disabled type="text" class="form-control c-n"
                                                           id="profile-organization"
                                                           name="organization"
                                                           value="TBT Brindes e Personalizados"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="zipCode" class="form-label">CEP</label>
                                                    <input disabled type="text" class="form-control"
                                                           id="profile-zipCode"
                                                           name="zipCode"
                                                           placeholder="12345-678" maxlength="9"/>
                                                    <div class="invalid-feedback" id="invalid-cep">
                                                        CEP não encontrado.
                                                    </div>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="state" class="form-label">Endereço</label>
                                                    <input disabled class="form-control" type="text" id="profile-logradouro"
                                                           name="logradouro"
                                                           placeholder="Ex: Av 123 de Oliveira 4"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="state" class="form-label">Número</label>
                                                    <input disabled class="form-control" type="text" id="profile-number"
                                                           name="number"
                                                           value="" placeholder="123"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="state" class="form-label">Bairro</label>
                                                    <input disabled class="form-control" type="text" id="profile-bairro"
                                                           name="bairro"
                                                           placeholder="Ex: Bom Retiro"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="state" class="form-label">Estado</label>
                                                    <input disabled class="form-control" type="text" id="profile-state"
                                                           name="state"
                                                           placeholder="SP" maxlength="2"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="complement" class="form-label">Complemento</label>
                                                    <input disabled type="text" class="form-control"
                                                           id="profile-complement"
                                                           name="complement"
                                                           placeholder="Ex: Bloco 123, apt 456"/>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label class="form-label" for="phoneNumber">Celular</label>
                                                    <div class="input-group input-group-merge">
                                                        <input disabled type="text" id="profile-mobile"
                                                               name="profile-mobile"
                                                               class="form-control"
                                                               placeholder="202 555 0111"/>
                                                    </div>
                                                </div>

                                                <div class="mb-3 col-md-6">
                                                    <label class="form-label" for="country">País</label>
                                                    <select disabled id="profile-country" class="select2 form-select">
                                                        <option value="">Brasil</option>
                                                        <option value="Australia">Australia</option>
                                                        <option value="Bangladesh">Bangladesh</option>
                                                        <option value="Belarus">Belarus</option>
                                                        <option value="Brazil">Brazil</option>
                                                        <option value="Canada">Canada</option>
                                                        <option value="China">China</option>
                                                        <option value="France">France</option>
                                                        <option value="Germany">Germany</option>
                                                        <option value="India">India</option>
                                                        <option value="Indonesia">Indonesia</option>
                                                        <option value="Israel">Israel</option>
                                                        <option value="Italy">Italy</option>
                                                        <option value="Japan">Japan</option>
                                                        <option value="Korea">Korea, Republic of</option>
                                                        <option value="Mexico">Mexico</option>
                                                        <option value="Philippines">Philippines</option>
                                                        <option value="Russia">Russian Federation</option>
                                                        <option value="South Africa">South Africa</option>
                                                        <option value="Thailand">Thailand</option>
                                                        <option value="Turkey">Turkey</option>
                                                        <option value="Ukraine">Ukraine</option>
                                                        <option value="United Arab Emirates">United Arab Emirates
                                                        </option>
                                                        <option value="United Kingdom">United Kingdom</option>
                                                        <option value="United States">United States</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="language" class="form-label">Idioma</label>
                                                    <select disabled id="profile-language" class="select2 form-select">
                                                        <option value="">Portugues - Brasil</option>
                                                        <option value="en">English</option>
                                                        <option value="fr">French</option>
                                                        <option value="de">German</option>
                                                        <option value="pt">Portuguese</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="timeZones" class="form-label">Fuso horário</label>
                                                    <select disabled id="profile-timeZones" class="select2 form-select">
                                                        <option value="">(GMT3) Brasília</option>
                                                        <option value="-12">(GMT3-14:00) Brasília</option>
                                                        <option value="-12">(GMT-12:00) International Date Line West
                                                        </option>
                                                        <option value="-11">(GMT-11:00) Midway Island, Samoa</option>
                                                        <option value="-10">(GMT-10:00) Hawaii</option>
                                                        <option value="-9">(GMT-09:00) Alaska</option>
                                                        <option value="-8">(GMT-08:00) Pacific Time (US & Canada)
                                                        </option>
                                                        <option value="-8">(GMT-08:00) Tijuana, Baja California</option>
                                                        <option value="-7">(GMT-07:00) Arizona</option>
                                                        <option value="-7">(GMT-07:00) Chihuahua, La Paz, Mazatlan
                                                        </option>
                                                        <option value="-7">(GMT-07:00) Mountain Time (US & Canada)
                                                        </option>
                                                        <option value="-6">(GMT-06:00) Central America</option>
                                                        <option value="-6">(GMT-06:00) Central Time (US & Canada)
                                                        </option>
                                                        <option value="-6">(GMT-06:00) Guadalajara, Mexico City,
                                                            Monterrey
                                                        </option>
                                                        <option value="-6">(GMT-06:00) Saskatchewan</option>
                                                        <option value="-5">(GMT-05:00) Bogota, Lima, Quito, Rio Branco
                                                        </option>
                                                        <option value="-5">(GMT-05:00) Eastern Time (US & Canada)
                                                        </option>
                                                        <option value="-5">(GMT-05:00) Indiana (East)</option>
                                                        <option value="-4">(GMT-04:00) Atlantic Time (Canada)</option>
                                                        <option value="-4">(GMT-04:00) Caracas, La Paz</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3 col-md-6">
                                                    <label for="currency" class="form-label">Moeda</label>
                                                    <select disabled id="profile-currency" class="select2 form-select">
                                                        <option value="">BRL</option>
                                                        <option value="brl">BRL</option>
                                                        <option value="usd">USD</option>
                                                        <option value="euro">Euro</option>
                                                        <option value="pound">Pound</option>
                                                        <option value="bitcoin">Bitcoin</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="mt-2">
                                                <input type="hidden" id="profile-id"
                                                       value="<?php echo $_SESSION['user']['id']; ?>">
                                                <button type="submit" class="btn btn-primary me-2"
                                                        id="btn-save-profile">Salvar
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- /Account -->
                                </div>
                                <div class="card">
                                    <h5 class="card-header">Alterar senha</h5>
                                    <div class="card-body">
                                        <div class="mb-3 col-12 mb-0">
                                            <a class="dropdown-item"
                                               onclick="modalChagePassword('<?= $_SESSION['user']['id'] ?>', '<?= $_SESSION['user']['nome'] ?>')"
                                               href="javascript:void(0);"><i class="bx bx-key me-1"></i>Alterar minha senha
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <?php if ($_SESSION['user']['nivel'] == 1): ?>
                                    <div class="card">
                                        <h5 class="card-header">Desativar minha conta</h5>
                                        <div class="card-body">
                                            <div class="mb-3 col-12 mb-0">
                                                <div class="alert alert-warning">
                                                    <h6 class="alert-heading fw-bold mb-1">Tem certeza de que deseja desativar sua conta?
                                                    </h6>
                                                    <p class="mb-0">Enviaremos a sua solicitação ao administrador do sistema!
                                                    </p>
                                                </div>
                                            </div>
                                            <div id="formAccountDeactivation">
                                                <div class="form-check mb-3">
                                                    <input type="hidden" id="delete-user-id" value="<?= $_SESSION['user']['id'] ?>">
                                                    <input class="form-check-input" type="checkbox" name="accountActivation" id="accountActivation">
                                                    <label class="form-check-label" for="accountActivation">Confirmo que desejo desativar minha conta</label>
                                                </div>
                                                <button type="submit" id="btn-deactivate-account" class="btn btn-danger deactivate-account">Desativar conta
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>


                    <div class="content-backdrop fade"></div>
                </div>

            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>


    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

</div>


<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_change_password.html';
?>
<!-- / Modals -->


<!-- Core JS -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/js/profile.js"></script>
<script src="assets/js/change-password.js"></script>

<!-- Page JS -->
<script src="assets/js/dashboards-analytics.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>
</body>

</html>