<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>


<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Status</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <!-- Helpers -->
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper ">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <h5 class="card-header">Status

                            <!-- <button type="button"
                                    class="btn w-px-20 h-px-20 mb-1 rounded-pill btn-icon btn-outline-secondary"
                                    title="Cadastrar novo status" data-bs-toggle="modal" data-bs-target="#modal-new-status">
                                <span class="tf-icons bx bx-plus"></span>
                            </button> -->
                        </h5>

                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Descrição</th>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="table-status-info">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/status/modal_create_status.html';
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/vendor/fattos/alert.js"></script>

<!-- <script src="assets/js/fees.js"></script> -->
<script src="assets/js/helpers.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script>

    const path_core = '../app/Core/';

    /**
     * Seletor do botão para cadastrar um novo status
     * 
     * @var btn_add_status
     */
    const btn_add_status = $('#btn-add-status');

    /**
     * Evento responsável por cadastrar um novo status no banco de dados
     */
    btn_add_status.on('click', function() {
        const nome = $('#modal-new-status-nome').val();
        const descricao = $('#modal-new-status-descricao').val();
        const fundo = $('#modal-new-status-cor-fundo').val();
        const fonte = $('#modal-new-status-cor-fonte').val();
        const ativo = Number($('#modal-new-status-padrao-ativo').is(':checked'));

        console.log('az: ' + ativo);
        if (nome == '') {
            fat_alert({
                type: 'warning',
                title: 'Oops...',
                message: 'Favor informar um nome!',
                timer: 3000
            });
            return;
        }

        btn_add_status.attr('disabled', true);

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Status.php`,
            data: {
                nome: nome,
                descricao, descricao,
                fundo: fundo,
                fonte: fonte,
                ativo: ativo,
                action: 'store'
            },
            success: function (data) {
                console.log(data);
                btn_add_status.attr('disabled', false);
                show().then((response) => renderInfoTable(response))

                $('.input-status').val('');
                $('#modal-new-status-preview-nome').text('Nome do Status');

                fat_alert({
                    type: 'success',
                    title: 'Successo!!!',
                    message: 'Status cadastrado com sucesso!',
                    timer: 3000
                });
            },
            error: function (xhr) {
                console.log(xhr);
                const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';

                fat_alert({
                    title: 'Erro',
                    message: errorMessage,
                    type: 'danger',
                    timer: 3000
                });

                return false;
            }
        });
    });

    async function show() {
        return await $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Status.php?action=show`,
        });
    }

    function renderInfoTable(data) {
        let html = '';

        if (data == '') {
            html += `
                <tr>
                    <td colspan="3" class="text-center"><small>Nenhum registro encontrado... 🤔</small></td>
                </tr>
            `;

            fat_alert({
                type: 'dark',
                title: 'Hey!!!',
                message: 'Que tal criar seu primeiro status personalizado? 🤓',
                timer: 5000
            });

            setTimeout(() => {                
                fat_alert({
                    type: 'dark',
                    title: 'Vamos lá? 💡',
                    message: 'Clique no botão "+" ao lado de "Status" para começar... ',
                    timer: 5000
                });
            }, 5000);
        }

        data.forEach(el => {

            isAtivo = el.ativo ? '<small class="ms-1 cursor-help text-secondary" title="Este status virá marcado como padrão ao realizar um orçamento"><u>(pré-selecionado)</u></small>' : '';

            html += `
                <tr>
                    <td>${el.nome} ${isAtivo}</td>
                    <td>${el.descricao}</td>
                </tr>
            `;
        });

        $('#table-status-info').html(html)
    }

    show().then((response) => renderInfoTable(response))
    /**
     * Evento responsável por atualizar a pré-visualização do nome com a cor
     */
    $('#modal-new-status-nome').on('keyup', function() {
        const value = $(this).val();

        if (value == '') {
            $('#modal-new-status-preview-nome').text('Nome do Status');
            return;
        }

        $('#modal-new-status-preview-nome').text(value);
    });


    var estiloAtual = {
        'background-color': '',
        'color': ''
    };

    $('#modal-new-status-cor-fundo').on('input', function() {
        const fundo = $(this).val();
        estiloAtual['background-color'] = `${fundo} !important`;
        aplicarEstilo();
    });

    $('#modal-new-status-cor-fonte').on('input', function() {
        const color = $(this).val();
        estiloAtual['color'] = `${color} !important`;
        aplicarEstilo();
    });

    function aplicarEstilo() {
        let estiloString = '';
        for (const prop in estiloAtual) {
            if (estiloAtual[prop] !== '') {
                estiloString += `${prop}: ${estiloAtual[prop]}; `;
            }
        }
        $('#modal-new-status-preview-nome').attr('style', estiloString);
    }

</script>

</body>

</html>