<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Suporte</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
            href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
            rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>
    <link rel="stylesheet" href="assets/css/demo.css"/>
    <link rel="stylesheet" href="assets/css/send-email-support.css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>
    <link rel="stylesheet" href="assets/vendor_template/libs/apex-charts/apex-charts.css"/>
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css"/>

    <!-- Page CSS -->
    <link rel="stylesheet" href="assets/css/dynamic-button-paginate.css">

    <!-- Helpers -->
    <script src="assets/vendor_template/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div id="body-customer" class="content-wrapper">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div id="card-customer" class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <h5 class="card-header">Suporte

                            <button type="button"
                                    class="btn w-px-20 h-px-20 mb-1 rounded-pill btn-icon btn-outline-secondary"
                                    title="Enviar e-mail" data-bs-toggle="modal"
                                    data-bs-target="#modal_send_mail_support" id="id-modal-new-mail_support">
                                <span class="tf-icons bx bx-plus"></span>
                            </button>
                        </h5>

                        <?php
                        $support = new App\Core\Support();

                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $limit_per_page = 10;

                        $paginate_views_support = $support->show($current_page, $limit_per_page);
                        ?>
                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead class="sticky-top">
                                <tr>
                                    <th>Assunto</th>
                                    <th>Descrição</th>
                                    <th>Data de envio</th>
                                    <th>Ver mais</th>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                <?php foreach ($paginate_views_support['data'] as $key => $value): ?>
                                    <?php
                                    $assuntoLimitado = (strlen($value['assunto']) > 35) ? substr($value['assunto'], 0, 35) . '...' : $value['assunto'];
                                    $descricaoLimitado = (strlen($value['descricao']) > 35) ? substr($value['descricao'], 0, 35) . '...' : $value['descricao'];
                                    $image = isset($value['img']) ? 'assets/file/support/' . $value['img'] : null;
                                    $descricao = $value['descricao'];

                                    ?>
                                    <tr>
                                        <td><?= $assuntoLimitado ?></td>
                                        <td><?= $descricaoLimitado ?></td>
                                        <td><?= date("d/m/Y", strtotime($value['created_at'])) ?></td>
                                        <td>
                                            <button type="button" id="modal-show-info-support"
                                                    class="btn w-px-20 h-px-20 mb-1 rounded-pill btn-icon btn-outline-secondary"
                                                    data-bs-target="modal-show-info-support"
                                                    style="border:none"
                                                    onclick="showModalMailSupport('<?= $value['assunto'] ?>', '<?= $descricao ?>', '<?= $value['created_at'] ?>', '<?= $image ?>')">
                                                <span class="tf-icons bx bx-show"></span>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>

                            </table>
                            <?php
                            echo '<div class="dynamic-pagination col text-center mb-3">' . $paginate_views_support['pages'] . '</div>';
                            ?>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_send_mail_support.html';
include __DIR__ . '/partials/modal/modal_show_mail_support.html';
?>
<!-- / Modals -->


<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor_template/js/menu.js"></script>
<script src="assets/vendor/select2/select2.min.js"></script>
<!-- endbuild -->

<!-- vendor_templates JS -->
<script src="assets/vendor_template/libs/apex-charts/apexcharts.js"></script>

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script src="assets/js/dashboards-analytics.js"></script>
<script src="assets/js/customer.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
<script src="assets/js/support.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

</body>

</html>