// src/composables/useBadges.js

/**
 * EM TESTES, NÃO ESTÁ SENDO UTILIZADO
 */
import axios from 'axios';
import { ref, getCurrentInstance } from 'vue';

export function useBadge(path_core) {
    const badges = ref([]);
    const { proxy } = getCurrentInstance();

    const obtemBadges = async (idOrcamento) => {
        
        try {
            const response = await axios.get(`${proxy.$path_core}OrdemServico.php?action=obtemBadges&idOrcamento=${idOrcamento}`);

            if (!response.data) return;

            // Garante que response.data.badges é um array
            const badgesData = response.data.badges ? JSON.parse(response.data.badges) : [];

            // Atualiza o estado das badges
            badges.value = badgesData.map(badge => ({
                text: badge.text,
                class: badge.class
            }));
        } catch (error) {
            console.error(error);
        }
    };

    const alteraBadge = async (item, badgeText, badgeClass) => {
        const badgeIndex = item.badges.findIndex(badge => badge.text === badgeText);
        if (badgeIndex === -1) {
            item.badges.push({ text: badgeText, class: badgeClass });
        } else {
            item.badges.splice(badgeIndex, 1);
        }

        try {
            await axios.post(`${proxy.$path_core}OrdemServico.php`,
                new URLSearchParams({
                    action: 'alteraBadge',
                    idOrcamento: item.id,
                    badges: JSON.stringify(item.badges)
                })
            );
        } catch (error) {
            console.error(error);
        }
    };

    return {
        badges,
        obtemBadges,
        alteraBadge
    };
}
