<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Usuários</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
            href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
            rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>
    <link rel="stylesheet" href="assets/css/demo.css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>


    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container control-dark-mode dark-mode light-mode">
        <!-- Menu -->

        <?php use App\Core\Helpers\Helper;

        include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <h5 class="card-header">Usuários
                            <?php if ($_SESSION['user']['nivel'] == 8 || $_SESSION['user']['nivel'] == 9): ?>
                                <button type="button"
                                        class="btn w-px-20 h-px-20 mb-1 rounded-pill btn-icon btn-outline-secondary"
                                        title="Cadastrar novo usuário" data-bs-toggle="modal"
                                        data-bs-target="#modal-new-user">
                                    <span class="tf-icons bx bx-plus"></span>
                                </button>
                            <?php endif; ?>
                        </h5>

                        <?php
                        $user = new App\Core\User;

                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $limit_per_page = 10;

                        $paginate_views_user = $user->show($current_page, $limit_per_page);
                        ?>

                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nome</th>
                                    <th>E-mail</th>
                                    <th>Nível</th>
                                    <?php if ($_SESSION['user']['nivel'] == 8 || $_SESSION['user']['nivel'] == 9): ?>
                                        <th>Status</th>
                                        <th>Ações</th>
                                    <?php endif; ?>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                <?php foreach ($paginate_views_user['data'] as $key => $value):
                                    $status = $value['status'] == 1 ? 'ativo' : 'inativo';
                                    $status_class = $value['status'] == 1 ? 'bg-label-primary' : 'bg-label-danger';

                                    $name_user = '"' . $value['nome'] . '"';

                                    $btn_toggle_status = $value['status'] == 1
                                        ? "<a class='dropdown-item' onclick='modalShowStatusUser({$value['id']}, {$value['status']}, {$name_user})'><i class='bx bx-user-x  me-1'></i>Inativar</a>"
                                        : "<a class='dropdown-item' type='button' onclick='modalShowStatusUser({$value['id']}, {$value['status']}, {$name_user})'><i class='bx bx-user-check  me-1'></i>Reativar</a>";

                                    ?>
                                    <tr>
                                        <td>
                                            <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                                <li data-bs-toggle="tooltip" data-popup="tooltip-custom"
                                                    data-bs-placement="top" class="avatar avatar-xs pull-up">
                                                    <img src="assets/file/user/<?= $value['img'] ?>"
                                                         onclick="showImage(this.src)"
                                                         onerror='this.src="assets/file/system/undraw_profile.svg"'
                                                         alt="Avatar" class="rounded-circle"/>
                                                </li>
                                            </ul>
                                        </td>
                                        <td><?= $value['nome'] ?></td>
                                        <td><?= $value['email'] ?></td>
                                        <td><?= App\Core\Helpers\Helper::printNivel($value['nivel']) ?></td>
                                        <?php if ($_SESSION['user']['nivel'] == 8 || $_SESSION['user']['nivel'] == 9): ?>
                                            <td><span class="badge <?= $status_class ?> me-1"><?= $status ?></span></td>
                                            <td>
                                                <div class="dropdown dropstart">
                                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                            data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item"
                                                           onclick="openModalUpdateUser('<?= $value['id'] ?>')"
                                                           href="javascript:void(0);"><i
                                                                    class="bx bx-edit-alt me-1"></i>Editar
                                                        </a>
                                                        <?= $btn_toggle_status ?>
                                                        <a class="dropdown-item"
                                                           onclick="modalChagePassword('<?= $value['id'] ?>', '<?= $value['nome'] ?>')"
                                                           href="javascript:void(0);"><i class="bx bx-key me-1"></i>Alterar
                                                            senha
                                                        </a>
                                                        <hr class="my-0">
                                                        <div class="dropdown-item">
                                                            <div class="form-check ps-4 pt-1">
                                                                <input 
                                                                    class="form-check-input" 
                                                                    type="checkbox" 
                                                                    data-tester-user-id="<?= $value['id'] ?>"
                                                                    id="tester-user-<?= $value['id']?>"
                                                                    <?= $value['tester'] == 1 ? 'checked' : '' ?>
                                                                >
                                                                <label class="form-check-label" for="tester-user-<?= $value['id']?>">
                                                                    Testador
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                            <?php
                            echo '<div class="dynamic-pagination col text-center my-3">' . $paginate_views_user['pages'] . '</div>';
                            ?>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>


    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

</div>


<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/user/modal_create_user.html';
include __DIR__ . '/partials/modal/user/modal_edit_user.html';
include __DIR__ . '/partials/modal/user/modal_enable_dasable_user.html';
include __DIR__ . '/partials/modal/modal_change_password.html';
include __DIR__ . '/partials/modal/modal_show_image.html';
?>
<!-- / Modals -->


<!-- Core JS -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/js/user.js"></script>
<script src="assets/js/change-password.js"></script>
</body>

</html>